package kr.util.sample;

import java.io.File;
import java.io.IOException;

import javax.sound.sampled.UnsupportedAudioFileException;

import kr.util.NotificationManager;
import kr.util.audio.AudioClip;
import kr.util.audio.MemAudioClip;
import kr.util.audio.WritableAudioClip;

/**
 * Handles retriving different kinds of files containing samples, such as mp3 and wav
 */
public class SampleManager 
{
	
	public SampleManager()
	{
	}
	
	/**
	 * Retrieves a ByteBuffer, one for each channel
	 * contained in the file
	 */
	public AudioClip getData(File sampleFile)
	{
		WritableAudioClip clip = new MemAudioClip(2,48000, 8); 

		try {
			SoundRetrievalManager.fillAudioClip(sampleFile, clip);
		} catch (UnsupportedAudioFileException e) {
			NotificationManager.inst().error("Audio file, "+sampleFile+", appears to be corrupt: "+e);			
			throw new IllegalArgumentException(e);
		} catch (IOException e) {
			NotificationManager.inst().error("IO error reading "+sampleFile+": "+e);
			throw new IllegalArgumentException(e);
		} 
		 
		return clip;
		
	}
}
