package kr.util.audio;

public class SingleChannelAudioClip extends AudioClip 
{
	private AudioClip source;

	private int channel;
	
	public SingleChannelAudioClip(int channel) {
		this.channel = channel;
	}
	@Override
	public int getNumChannels() {
		return 1;
	}
	@Override
	public int length() {
		if(source == null) return 0;
		return source.length()/ source.getNumChannels();
	}
	
	@Override
	public int getRate() {
		if(source == null) return 0;
		return source.getRate();
	}
	
	@Override
	public int getSampleSizeInBits() {
		if(source == null) return 0;
		return source.getSampleSizeInBits();
	}
	
	
	@Override
	public byte byteAt(int index) {
		if(source == null) return 0;
		
		int frameIndex = index / (source.getSampleSizeInBits() / 8);
		
		int sourceIndex = frameIndex * (source.getSampleSizeInBits() / 8) * 2 + channel * (source.getSampleSizeInBits() / 8) + index % (source.getSampleSizeInBits() / 8);
		
		return source.byteAt(sourceIndex);
	}
	
	@Override
	public void copyTo(int offset, int length, byte[] dest, int destOffset) {
		//PERF: slow
		for(int i = 0; i < length; i++)
		{
			dest[offset + i] = byteAt(offset+i);
		}
	}
	
	public AudioClip getSource() {
		return source;
	}

	public void setSource(AudioClip source) {
		this.source = source;
	}

}
