package kr.miditunemodel;

import java.util.ArrayList;
import java.util.List;

import kr.miditunemodel.MidiTuneModel.MessageType;
import kr.util.ListenerManager;

import kr.util.Util;

public class NoteEventGroup extends EventGroup<NoteEvent> 
{
	
	/**
	 * Creates a note event with the given start micros and returns
	 * the note event
	 */
	public NoteEvent createNoteEvent(byte note, long micros) {
		
		NoteEvent newItem = new NoteEvent(note, 0x4e, //common KR midi strength 
				micros);
		
		newItem.setEndMicros(micros+50*1000);
		
		insertEvent(newItem);
		
		return newItem;
	}

	public MidiTransaction createTransaction() {
		return new MidiNoteTransaction(this);
	}

}
