package kr.gui.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

import javax.swing.event.MouseInputAdapter;

public class UIModeHandler {
	private List<UIMode> modeStack = new ArrayList<UIMode>();
	private Component comp;
	
	public UIModeHandler(Component c)
	{
		this.comp = c;
	}

	public void removeMode(UIMode mode) {
		if(removeMode() != mode) 
			throw new IllegalArgumentException("Tried to remove the wrong node");
	}
	
	public UIMode removeMode() {
		UIMode actMode = modeStack.remove(modeStack.size() - 1);
		actMode.stop(comp);

		if(modeStack.size() != 0)
		{
			UIMode lastMode = modeStack.get(modeStack.size() - 1);
			lastMode.start(comp);
		}

		
		return actMode;
	}
	
	/**
	 * Adds a new mode to the stack and adds it as a listener to the MidiGraph.
	 */
	public void addMode(UIMode mode) {
		if(modeStack.size() != 0)
		{
			UIMode lastMode = modeStack.get(modeStack.size() - 1);
			lastMode.stop(comp);
		}
		modeStack.add(mode);
		mode.start(comp);
	}
	
	/**
	 * Replaces the current mode with a new one.
	 */
	public void replaceMode(UIMode mode) {
		if(modeStack.size() != 0)
		{
			UIMode lastMode = modeStack.remove(modeStack.size() - 1);
			lastMode.stop(comp);
		}
		modeStack.add(mode);
		mode.start(comp);
	}


}
