package kr.gui.util;

import javax.swing.text.PlainDocument;
import javax.swing.text.Document;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

/**
 * An insert restrictor restricts input to a field. For example, a max length restrictor
 * can restrict the maximum length of a field. InsertRestrictors can be chained together 
 * to perform multiple restrictions, see RestrictedField
 */
public abstract class InsertRestrictor
{
	private InsertRestrictor chain;
	
	public InsertRestrictor()
	{
	}
	
	void chain(InsertRestrictor chain)
	{
		this.chain = chain;
	}

	/**
	 * Intercepts an insert. Whatever is returned is actually inserted into the field
	 */
	protected abstract String insertStringImpl(Document d, int offs, 
											   String str,
											   AttributeSet a) 
		throws BadLocationException;
	
	
	public String insertString(Document d, int offs, 
							   String str,
							   AttributeSet a) 
		throws BadLocationException 
	{
		String s = insertStringImpl(d, offs, str, a);
		if(chain != null)
			s = chain.insertStringImpl(d, offs, s, a);
		
		return s;
	}

}
