package kr.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Dictionary;
import java.util.Hashtable;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.Timer;

import kr.gui.util.MilliTimeLabelTable;

public class TimePanel extends JPanel {
	private Model model;
	TimeController timeController;
	JButton play, stop, playLoop;
	JSlider timeSlider;
	JRadioButton halfSpeed;
	JRadioButton threeQuartersSpeed;
	JRadioButton fullSpeed;

	public TimePanel(Model model, TimeController timeController) 
	{
		this.model = model;
		this.timeController = timeController;
		init();
		timeController.init(model,model.getGuiModel(),this);
	}

	private void init()
	{
        setLayout(new GridBagLayout());
        
        int maxMillis = model.getMaxMilliSeconds();

        //Create the slider.
        timeSlider = new JSlider(JSlider.HORIZONTAL,
                                              0, maxMillis, 0);
        timeSlider.setLabelTable(new MilliTimeLabelTable(30 * 1000)); //30 second spacing

        timeSlider.setMajorTickSpacing(30 * 1000);
        timeSlider.setMinorTickSpacing(10 * 1000);
        timeSlider.setPaintTicks(true);
        
        //Turn on labels at major tick marks.
        timeSlider.setPaintLabels(true);
        
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = c.weighty = 1;
        c.fill = c.BOTH;
        c.gridx=c.gridy=0;
        c.gridwidth=6;
       
        add(timeSlider,c);
        
        c.weightx = c.weighty = 0;
        c.gridwidth=1;
        c.gridy++;
        c.gridx=0;
        c.anchor=c.WEST;
        c.fill=c.NONE;
        add(play = new JButton("Play"),c);
        c.gridx++;
        add(playLoop = new JButton("Play Loop"),c);
        c.gridx++;
        add(stop = new JButton("Stop"),c);
        
        ButtonGroup bg = new ButtonGroup();
        
        c.gridx++;
        add(halfSpeed = new JRadioButton("1/2 speed"),c);
        c.gridx++;
        add(threeQuartersSpeed = new JRadioButton("3/4 speed"),c);
        c.weightx=1;
        c.gridx++;
        add(fullSpeed = new JRadioButton("Full speed"),c);
        
        bg.add(threeQuartersSpeed);
        bg.add(halfSpeed);
        bg.add(fullSpeed);
        
        fullSpeed.setSelected(true);
 	}

	public void updateSliderValue() {
		timeSlider.setValue((int)(model.getGuiModel().getNowMicros()/1000));
	}
	
	public void updateSliderMax()
	{
		timeSlider.setMaximum(model.getMaxMilliSeconds());
	}

}
