package kr.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

import kr.util.NotificationManager;

public class KRStatusPanel extends JPanel {
	private JProgressBar bar;
	private JLabel status;

	public KRStatusPanel()
	{
		init();
	}
	
	private void init()
	{
		setLayout(new GridBagLayout());

        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1; c.weighty = 0;
        c.fill = c.BOTH;
        c.gridx=c.gridy=0;
        c.gridwidth=c.gridheight=1;
       
        c.insets = new Insets(3,0,3,0);
        add(status = new JLabel("Welcome to KR Maker"),c);

        c.gridx++;  
        c.insets = new Insets(0,0,0,0);
        add(bar = new JProgressBar(),c);
        
        NotificationManager.inst().setProgressBar(bar);        
        NotificationManager.inst().setStatusLabel(status);
	}
	
	
}
