package kr;

import kr.util.Listener;
import kr.util.ListenerManager;
import kr.util.audio.AudioClip;
import kr.util.audio.EffectAudioClip;
import kr.util.audio.GainAudioClip;
import kr.util.audio.SubtractedBkgAudioClip;

public class AudioChannelModel implements Listener
{
	private AudioClip clip;
	private AudioChannelModel deriveChannelModel;
	private EffectAudioClip deriveClip;
	
	public static enum MessageType { AUDIO_CLIP_CHANGED };
	
	public AudioChannelModel()
	{
	}

	public AudioClip getClip() {
		if(deriveChannelModel != null)
			return deriveClip;
		return clip;
	}

	public void setClip(AudioClip clip) {
		doNotDerive();
		this.clip = clip;
		ListenerManager.inst().notify(this, MessageType.AUDIO_CLIP_CHANGED);
	}

	public void deriveFrom(EffectAudioClip deriveClip, AudioChannelModel deriveChannelModel) {
		this.deriveClip = deriveClip;
		this.deriveChannelModel = deriveChannelModel;
		deriveClip.setSource(deriveChannelModel.getClip());
		
		ListenerManager.inst().registerListener(deriveChannelModel, this);
		ListenerManager.inst().notify(this, MessageType.AUDIO_CLIP_CHANGED);
	}

	public void notify(Object source, Object type, Object... values) {
		if(source == deriveChannelModel)
		{
			if(type == MessageType.AUDIO_CLIP_CHANGED)
			{
				deriveClip.setSource(deriveChannelModel.getClip());
				ListenerManager.inst().notify(this, MessageType.AUDIO_CLIP_CHANGED);
			}
		}
	}

	public void doNotDerive() {
		if(deriveChannelModel == null)
			return;
		
		ListenerManager.inst().unregisterListener(deriveChannelModel, this);
		deriveChannelModel = null;
		deriveClip = null;

		ListenerManager.inst().notify(this, MessageType.AUDIO_CLIP_CHANGED);
	}
	
}
