import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;

public class RandomMidiSong {
	public static void main(String [] args) throws Exception
	{
		Synthesizer synthesizer = MidiSystem.getSynthesizer();
		synthesizer.open();
		Receiver receiver = synthesizer.getReceiver();
		
		for(int i = 0; i < 100; i++)
		{
			int note = (int)(Math.random() * 128);
			
			ShortMessage m = new ShortMessage();
			
			m.setMessage(ShortMessage.NOTE_ON, 0, note, 0x50);
			
			receiver.send(m, -1);
			
			Thread.sleep(1000);

			m.setMessage(ShortMessage.NOTE_ON, 0, note, 0);
			
			receiver.send(m, -1);
		}
		
	}

}
