package kr.util.ft;

import kr.gui.midigraph.ColoredScaleUI;
import kr.gui.midigraph.ColoredScaleUI.DataSet;
import kr.gui.midigraph.ColoredScaleUI.ScaleData;

public class SubtractScaleData  implements ColoredScaleUI.ScaleData
{

	private ScaleData a;
	private ScaleData b;

	public SubtractScaleData(ScaleData a, ScaleData b) {
		this.a = a;
		this.b = b;
	}

	public DataSet getDataSet(double microsPos) {
		DataSet ad = a.getDataSet(microsPos);
		DataSet bd = b.getDataSet(microsPos);
		
		DataSet nd = new DataSet();
		
		nd.microsStart = Math.max(ad.microsStart, bd.microsStart);
		nd.microsEnd = Math.max(ad.microsEnd, bd.microsEnd);
		
		//PERF: maybe create arrays of data ahead of time
		nd.noteValues = new byte[ad.noteValues.length];
		
		for(int i=0; i < ad.noteValues.length; i++)
		{
			nd.noteValues[i] = (byte) Math.max(ad.noteValues[i] - bd.noteValues[i], 0);
		}
		
		return nd;
	}

}
