package kr.miditunemodel;

public abstract class ChangeEventOperation<T extends Event> extends MidiOperation<T> 
{
	private long microsDelta;
	private long endMicrosDelta;
	
	public ChangeEventOperation(T event)
	{
		super(event);
	}
	

	public void setNewMicros(long newMicros)
	{
		this.microsDelta = newMicros - event.getMicros();
	}
	
	public void setNewEndMicros(long newEndMicros)
	{
		this.endMicrosDelta = newEndMicros - event.getEndMicros();
	}


	public void undo() 
	{
		event.setMicros(event.getMicros() - microsDelta);
		event.setEndMicros(event.getEndMicros() - endMicrosDelta);
	}

	public void doIt() 
	{
		event.setMicros(event.getMicros() + microsDelta);
		event.setEndMicros(event.getEndMicros() + endMicrosDelta);
	}

	public void setMicrosDelta(long microsDelta) {
		this.microsDelta = microsDelta;
	}

	public void setEndMicrosDelta(long endMicrosDelta) {
		this.endMicrosDelta = endMicrosDelta;
	}

	public boolean isValid() {
		if(event.getMicros() < 0)
			return false;
		return true;
		
	}

	
}
