package kr.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import kr.gui.GainPanel.SubPanel;

public class GainSubPanelController implements ActionListener, ChangeListener
{

	private final GainPanel panel;
	private SubPanel subPanel;
	private int lineNumber;

	public GainSubPanelController(GainPanel panel, SubPanel subPanel, int lineNumber) {
		this.panel = panel;
		this.lineNumber = lineNumber;
		this.subPanel = subPanel;
		subPanel.getSlider().addChangeListener(this);
		subPanel.getMutedCheckBox().addActionListener(this);
	}

	public void actionPerformed(ActionEvent e) {
		this.panel.mixer.updateMuteFlag(subPanel.getMutedCheckBox().isSelected(), lineNumber);
	}

	public void stateChanged(ChangeEvent e) {
		this.panel.mixer.updateVolume(subPanel.getSlider().getValue() / 100f, lineNumber);
	}
	
}
