//package kr;
//
//import javax.media.ControllerClosedEvent;
//import javax.media.ControllerEvent;
//import javax.media.ControllerListener;
//import javax.media.Processor;
//
//public class JMFUtil {
//	private enum ActionType {
//		CONFIGURE(Processor.Configured), REALIZE(Processor.Realized),
//		START(Processor.Started), STOP(Processor.Prefetched);
//		
//		private int processorState;
//
//		ActionType(int processorState)
//		{
//			this.processorState = processorState;
//		}
//		
//		public int getProcessorState()
//		{
//			return processorState;
//		}
//	};
//
//	public static void configure(Processor proc) {
//		doAction(proc, ActionType.CONFIGURE);
//	}
//
//	public static void realize(Processor proc) {
//		doAction(proc, ActionType.REALIZE);
//	}
//
//	public static void start(Processor proc) {
//		doAction(proc, ActionType.START);
//	}
//
//	public static void stop(Processor proc) {
//		doAction(proc, ActionType.STOP);
//	}
//
//	private static void doAction(Processor proc, ActionType actionType) {
//		StateListener sl = new StateListener(proc);
//		try {
//			synchronized (sl) {
//				if (actionType == ActionType.CONFIGURE)
//					proc.configure();
//				else if (actionType == ActionType.REALIZE)
//					proc.realize();
//				else if (actionType == ActionType.START)
//					proc.start();
//				else if (actionType == ActionType.STOP)
//					proc.stop();
//				try {
//					while (proc.getState() != actionType.getProcessorState() && sl.failed == false) {
//						sl.wait();
//					}
//				} catch (InterruptedException e) {
//				}
//			}
//
//			if (sl.failed)
//				throw new IllegalStateException("Failed!");
//
//		} finally {
//			sl.cleanUp();
//		}
//	}
//
//	private static class StateListener implements ControllerListener {
//		private Processor proc;
//
//		boolean failed = false;
//
//		public StateListener(Processor proc) {
//			this.proc = proc;
//			proc.addControllerListener(this);
//		}
//
//		public void cleanUp() {
//			proc.removeControllerListener(this);
//		}
//
//		public void controllerUpdate(ControllerEvent ce) {
//			System.out.println("Controller Event "+ce);
//			if (ce instanceof ControllerClosedEvent)
//				failed = true;
//
//			if (ce instanceof ControllerEvent)
//				synchronized (this) {
//					notifyAll();
//				}
//		}
//	}
//
//}
