package kr.gui.metrodome;

import java.util.SortedSet;
import java.util.TreeSet;

import kr.miditunemodel.EventGuiModel;
import kr.miditunemodel.MetrodomeEvent;
import kr.miditunemodel.MidiTuneModel;
import kr.miditunemodel.NoteEvent;
import kr.miditunemodel.NoteEventGuiModel.MessageType;
import kr.util.ListenerManager;
import kr.util.audio.AudioClip;
import kr.util.audio.MidiAudioClip;

public class MetrodomeGuiModel  extends EventGuiModel<MetrodomeEvent>
{
	private SortedSet<Long> beats = new TreeSet<Long>();
	
	public MetrodomeGuiModel(MidiTuneModel midiTuneModel) {
		super(midiTuneModel.getMetrodomeEventGroup());
	}

	public void addBeat(long nowMicros) {
		beats.add(nowMicros);
	}
	
	public void clearBeats()
	{
		beats.clear();
	}
	
	public Iterable<Long> getBeats(long startMicros, long endMicros)
	{
		return beats.subSet(startMicros, endMicros);
	}
}
