package kr.gui;

import java.util.HashMap;
import java.util.Map;

public class DebugTimer {
	private static Map<String,Stat> stats = new HashMap<String, Stat>();
	
	public static void start(String name)
	{
		Stat s = stats.get(name);
		if(s == null)
		{
			stats.put(name, s = new Stat());
		}
		s.currStartTime = System.currentTimeMillis();
	}
		
	public static void end(String name)
	{
		Stat s = stats.get(name);
		s.totalTime += System.currentTimeMillis() - s.currStartTime;
		s.totalRuns++;
	}
	
	public static void printStats()
	{
		for(String name : stats.keySet())
		{
			Stat s = stats.get(name);
			String shortName = name;
			if(shortName.length() > 20) shortName = shortName.substring(0,20);
			System.out.println(String.format("%-20s: Total Runs %6d, Total time %10.3f secs, Avg time %1.8f secs", 
					name,s.totalRuns, s.totalTime / 1000., (double)s.totalTime / s.totalRuns/1000.));
		}
	}

	private static class Stat
	{
		long currStartTime;
		int totalRuns;
		long totalTime;
	}
}
