Attribute VB_Name = "modINI"
'********************************************
'
'XSkin by Osiris
'www.osirishq.com
'contact@osirishq.com
'IRC As XBZ|Osi or [Osiris] or [Osi]
'
'Feel free to modify this program in any way
'just give credit where it is due. :)
'If you have any comments, complaints,
'suggestion, or anything else drop me an
'email at contact@osirishq.com
'
'Peace
'
'This module is going to be used to load
'a previously saved skin. Haven't got around
'to implementing it yet. :P
'
'********************************************

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' Description: This file contains all code required to access ini files
'
' Created By:  Barry Dunne
' Date Created: 7 Jan 2000
'
'
' Public Interface:
'
'  Function sReadIniFileString(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, Optional ByVal Default As String = "") As String
'    - Read a string from the given ini file
'  Function lReadIniFileLong(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, Optional ByVal Default As Long = 0) As Long
'    - Read an integer from the given ini file
'  Function dReadIniFileDouble(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, Optional ByVal Default As Double = 0) As Double
'    - Read a decimal value from the given ini file
'  Function dtReadIniFileDate(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, Optional ByVal Default As Date = "1 Jan 1900") As Date
'    - Read a date from the given ini file
'  Function colReadIniFileSection(ByVal IniFile As String, ByVal Section As String) As Collection
'    - Returns a collection containing all entries for the given section
'  Function bWriteIniFileString(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, ByVal Value As String) As Boolean
'    - Write a string to the ini file
'  Function bWriteIniFileLong(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, ByVal Value As Long) As Boolean
'    - Write an integer to the ini file
'  Function bWriteIniFileDouble(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, ByVal Value As Double) As Boolean
'    - Write a decimal value to the ini file
'  Function bWriteIniFileDate(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, ByVal Value As Date) As Boolean
'    - Write a date to the ini file
'  Function colReadIniFileSectionNames(ByVal IniFile As String) As Collection
'    - Returns a collection containing all sections for the given ini file
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Option Explicit
Private Declare Function GetPrivateProfileSection Lib "kernel32" Alias "GetPrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function GetPrivateProfileSectionNames Lib "kernel32" Alias "GetPrivateProfileSectionNamesA" (ByVal lpszReturnBuffer As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
Private Const MAX_STRING_LEN As Long = 500
Private Const MAX_SECTION_LEN As Long = 10000
'Read a string from an ini file
Public Function sReadIniFileString(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, Optional ByVal Default As String = "") As String
  On Error GoTo sReadIniFileString_err
  
  Dim nLength As Long
  Dim sTemp As String
  
  sTemp = Space$(MAX_STRING_LEN)
  nLength = GetPrivateProfileString(Section, Key, Default, sTemp, MAX_STRING_LEN, IniFile)
  sReadIniFileString = Mid$(sTemp, 1, nLength)
  
  Exit Function
  
sReadIniFileString_err:
  sReadIniFileString = Default
End Function
'Read a long integer from an ini file
Public Function lReadIniFileLong(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, Optional ByVal Default As Long = 0) As Long
  On Error GoTo lReadIniFileLong_err
  
  Dim sTemp As String
  
  'Use existing function to get value back as string
  sTemp = sReadIniFileString(IniFile, Section, Key, "")
  
  If Len(sTemp) = 0 Then
    lReadIniFileLong = Default
  Else
    lReadIniFileLong = CLng(sTemp)
  End If
  
  Exit Function
  
lReadIniFileLong_err:
  lReadIniFileLong = Default
End Function
'Read a double from an ini file
Public Function dReadIniFileDouble(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, Optional ByVal Default As Double = 0) As Double
  On Error GoTo dReadIniFileDouble_err
  
  Dim sTemp As String
  
  'Use existing function to get value back as string
  sTemp = sReadIniFileString(IniFile, Section, Key, "")
  
  If Len(sTemp) = 0 Then
    dReadIniFileDouble = Default
  Else
    dReadIniFileDouble = CDbl(sTemp)
  End If
  
  Exit Function
  
dReadIniFileDouble_err:
  dReadIniFileDouble = Default
End Function
'Read a date from an ini file
Public Function dtReadIniFileDate(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, Optional ByVal Default As Date = "1 Jan 1900") As Date
  On Error GoTo dtReadIniFileDate_err
  
  Dim sTemp As String
  
  'Use existing function to get value back as string
  sTemp = sReadIniFileString(IniFile, Section, Key, "")
  
  If Len(sTemp) = 0 Then
    dtReadIniFileDate = Default
  Else
    If IsDate(sTemp) Then
      dtReadIniFileDate = sTemp
    Else
      dtReadIniFileDate = Default
    End If
  End If
  
  Exit Function
  
dtReadIniFileDate_err:
  dtReadIniFileDate = Default
End Function
'This will return a collection containing all entries for a given section
Public Function colReadIniFileSection(ByVal IniFile As String, ByVal Section As String) As Collection
  On Error GoTo colReadIniFileSection_err
  
  Dim sTemp As String
  Dim nPos As Long
  Dim nLength As Long
  
  Set colReadIniFileSection = New Collection
  
  sTemp = Space$(MAX_SECTION_LEN)
  nLength = GetPrivateProfileSection(Section, sTemp, MAX_SECTION_LEN, IniFile)
  sTemp = Mid$(sTemp, 1, nLength)
  nPos = InStr(1, sTemp, "=")
  Do While nPos > 0
    colReadIniFileSection.Add Mid$(sTemp, 1, nPos - 1)
    nPos = InStr(1, sTemp, Chr$(0))
    sTemp = Mid$(sTemp, nPos + 1)
    nPos = InStr(1, sTemp, "=")
    DoEvents
  Loop
  
  If Len(sTemp) > 0 Then
    colReadIniFileSection.Add sTemp
  End If
  
  Exit Function
colReadIniFileSection_err:
  
End Function
'Write a string to an ini file
Public Function bWriteIniFileString(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, ByVal Value As String) As Boolean
  On Error GoTo bWriteIniFileString_err
  
  Dim nRetVal As Long
  
  'Clear existing entry first
  '(there is a problem with encrypted values otherwise)
  WritePrivateProfileString Section, Key, vbNullString, IniFile
  bWriteIniFileString = WritePrivateProfileString(Section, Key, Value, IniFile)
  
  If nRetVal > 0 Then
    bWriteIniFileString = True
  Else
    bWriteIniFileString = False
  End If

  Exit Function

bWriteIniFileString_err:
  bWriteIniFileString = False
End Function
'Write a long integer to an ini file
Public Function bWriteIniFileLong(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, ByVal Value As Long) As Boolean
  bWriteIniFileLong = bWriteIniFileString(IniFile, Section, Key, CStr(Value))
End Function
'Write a double to an ini file
Public Function bWriteIniFileDouble(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, ByVal Value As Double) As Boolean
  bWriteIniFileDouble = bWriteIniFileString(IniFile, Section, Key, CStr(Value))
End Function
'Write a date to an ini file
Public Function bWriteIniFileDate(ByVal IniFile As String, ByVal Section As String, ByVal Key As String, ByVal Value As Date) As Boolean
  bWriteIniFileDate = bWriteIniFileString(IniFile, Section, Key, Format$(Value, "dd mmm yyyy hh:nn:ss"))
End Function
'This will return a collection containing all entries for a given section
Public Function colReadIniFileSectionNames(ByVal IniFile As String) As Collection
  On Error GoTo colReadIniFileSectionNames_err
  
  Dim sTemp As String
  Dim nPos As Long
  Dim nLength As Long
  
  Set colReadIniFileSectionNames = New Collection
  
  sTemp = Space$(MAX_SECTION_LEN)
  nLength = GetPrivateProfileSectionNames(sTemp, MAX_SECTION_LEN, IniFile)
  sTemp = Mid$(sTemp, 1, nLength)
  nPos = InStr(1, sTemp, Chr$(0))
  Do While nPos > 0
    colReadIniFileSectionNames.Add Mid$(sTemp, 1, nPos - 1)
    sTemp = Mid$(sTemp, nPos + 1)
    nPos = InStr(1, sTemp, Chr$(0))
    DoEvents
  Loop
  
  If Len(sTemp) > 0 Then
    colReadIniFileSectionNames.Add sTemp
  End If
  
  Exit Function
colReadIniFileSectionNames_err:
End Function
'This will remove an entry
Public Function bRemoveIniFileEntry(ByVal IniFile As String, ByVal Section As String, ByVal Key As String) As Boolean
  On Error GoTo bRemoveIniFileEntry_err

  bRemoveIniFileEntry = False

  If WritePrivateProfileString(Section, Key, vbNullString, IniFile) > 0 Then
    bRemoveIniFileEntry = True
  Else
    bRemoveIniFileEntry = False
  End If

bRemoveIniFileEntry_err:
End Function

