/*
	Copyright 2003 Chris Cavey
	
	This file is part of XID.
	
	XID is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	XID is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with XID; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _XID_CONFIG_H
#define _XID_CONFIG_H
	
#ifdef __cplusplus
extern "C"
{
#endif
	// Since I'm set on using C++, I think it's proper to include this headers via C style
	#include "wdm.h"
#ifdef __cplusplus
}
#endif

#include "xidtypes.h"

#define XIDFEATURETYPE_BUTTON 1
#define XIDFEATURETYPE_AXIS 2
#define XIDFEATURETYPE_HAT 3
#define XIDFEATURETYPE_CONSTANT 4
#define XIDFEATUREFLAG_INVERT 1

// The following can be though of as communication packets sent by outside source
// to convince the driver to alter the way in which it parses data.
// since we recieve this in serial bytes, they MUST be packed on 1 byte alignment.
#include <pshpack1.h>
struct XIDFEATURE_BUTTON
{
	BYTE virtualButton, physicalControl, flags;
	WORD threshold;
	SHORT x1, y1, x2, y2, xh, yh;
	BYTE type;
};
struct XIDFEATURE_AXIS
{
	BYTE virtualAxis, physicalControl, flags;
	WORD threshold;
	BYTE type;
};

struct XIDFEATURE_HAT
{
	BYTE hatIndex, physicalControl, flags;
	WORD threshold;
	SHORT x1, y1, x2, y2, xh, yh;
	BYTE type;
};
#include <poppack.h>

class XIDCONFIG
{
	private:
		XIDFEATURE_BUTTON buttonMap[16];
		XIDFEATURE_AXIS axisMap[8];
		XIDFEATURE_HAT hat[8]; // maps to the 8 point hat
		DWORD genConfig, buttonConfig;

		BYTE processButtonFeature(XIDFEATURE_BUTTON *);
		BYTE processAxisFeature(XIDFEATURE_AXIS *);
		BYTE processHatFeature(XIDFEATURE_HAT *);
		DWORD readRegDword(WCHAR *entry, DWORD *);
		DWORD readRegBinary(WCHAR *, void *, signed long);
	public:
		void initializeInternalConfigDesc();
		void updateInternalConfigDesc(BYTE *, DWORD);
		// accessor functions
		DWORD getGeneralConfig();
		DWORD getButtonConfig();
		BYTE getButtonType(BYTE);
		const XIDFEATURE_BUTTON *getButtonMap(BYTE index) { return (const XIDFEATURE_BUTTON *)&buttonMap[index]; };
		const XIDFEATURE_AXIS *getAxisMap(BYTE index) { return (const XIDFEATURE_AXIS *)&axisMap[index]; };
		const XIDFEATURE_HAT *getHat() { return (const XIDFEATURE_HAT *)&hat; };
};

#endif