/*
	Copyright 2003 Chris Cavey
	
	This file is part of XID.
	
	XID is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	XID is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with XID; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include "XIDInterface.h"

using namespace std;

int main()
{
	XID::ControllerEnumerator test;
	XID::Controller *pad;

	test.refreshControllerList();

	// the enumeration and basic button mapping should remain unchanged
	// there is no gurantee that a pad unplugged and plugged into a different usb port
	// will identify as the same pad. 
	
	// TODO: provide callbacks for device removal? If possible?

	cout << "Found " << test.controllerCount() << " controller" << ((test.controllerCount() == 1) ? "..." : "s...") << endl << endl;
	for(unsigned int x = 0; x < test.controllerCount(); x++)
	{
		pad = test.getController(x);
		if(pad != NULL)
			cout << "(" << x << ") " << pad->description() << endl;

		// just mess with the first pad.
		if(x == 0)
		{
			pad->disable();
			pad->enable();
			pad->mapAxis(0,28,0);
			pad->mapAxis(1,27,0, FLAG_INVERT);
			/*
			for(unsigned int y = 0; y < 256; y++)
			{
				DWORD dwStart = GetTickCount();
				// busy wait for 100ms between each rumble command, 255 * 100ms = 25.5s
				while(GetTickCount() - dwStart < 100); 
				pad->rumble(y < 128 ? y : 255-y, 0);
			}
			*/
		}
	}

	cin.get();
}