// ---------------------------------------------------- //
//                      WinIo v2.0                      //
//  Direct Hardware Access Under Windows 9x/NT/2000/XP  //
//           Copyright 1998-2002 Yariv Kaplan           //
//               http://www.internals.com               //
// ---------------------------------------------------- //


#include <sys/io.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include "port_io.h"

#undef DEBUG

bool  GetPortVal(WORD wPortAddr, DWORD * pdwPortVal, BYTE bSize)
{
	switch (bSize)
	{
		case 1:
			*pdwPortVal = inb(wPortAddr);
			break;
		case 2:
			*pdwPortVal = inw(wPortAddr);
			break;
		case 4:
			*pdwPortVal = inl(wPortAddr);
			break;
	}

	#ifdef DEBUG
	printf("GetPortVal Port 0x%03x Value 0x%04x\n",wPortAddr,*pdwPortVal);
	#endif
	return true;
}


bool  SetPortVal(WORD wPortAddr, DWORD dwPortVal, BYTE bSize)
{
	switch (bSize)
	{
		case 1:
			outb(dwPortVal,wPortAddr);
			break;
		case 2:
			outw(dwPortVal,wPortAddr);
			break;
		case 4:
			outl(dwPortVal,wPortAddr);
			break;
	}
	#ifdef DEBUG
	printf("SetPortVal Port 0x%03x Value 0x%04x\n",wPortAddr,dwPortVal);
	#endif
	return true;
}


//**********************************************************************
//       Routines for BioX  (c) 2002 by W. Meyer ChipTech GmbH
//**********************************************************************

bool  SetAdr(WORD wPortAddr, DWORD dwPortVal, BYTE bconf) //, BYTE bSize)
{
	// port 1
	SetPortVal(wPortAddr, (240 & par_set_0) | 1,1);
	SetPortVal(wPortAddr, (240 & par_set_0 & par_set_clk_0) | 1,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_set_0) | 1,1);}
	SetPortVal(wPortAddr, 240  | (dwPortVal & 15),1);
	SetPortVal(wPortAddr, (240 & par_set_clk_0) | (dwPortVal & 15),1);
	if (bconf == 1) {SetPortVal(wPortAddr, 240  | (dwPortVal & 15),1);}
	// port 2
	SetPortVal(wPortAddr, (240 & par_set_0) | 2,1);
	SetPortVal(wPortAddr, (240 & par_set_0 & par_set_clk_0) | 2,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_set_0) | 2,1);}
	SetPortVal(wPortAddr, 240  | ((dwPortVal>>4) & 15),1);
	SetPortVal(wPortAddr, (240 & par_set_clk_0) | ((dwPortVal>>4) & 15),1);
	if (bconf == 1) {SetPortVal(wPortAddr, 240  | ((dwPortVal>>4) & 15),1);}
	// port 3
	SetPortVal(wPortAddr, (240 & par_set_0) | 3,1);
	SetPortVal(wPortAddr, (240 & par_set_0 & par_set_clk_0) | 3,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_set_0) | 3,1);}
	SetPortVal(wPortAddr, 240  | ((dwPortVal>>8) & 15),1);
	SetPortVal(wPortAddr, (240 & par_set_clk_0) | ((dwPortVal>>8) & 15),1);
	if (bconf == 1) {SetPortVal(wPortAddr, 240  | ((dwPortVal>>8) & 15),1);}
	// port 4
	SetPortVal(wPortAddr, (240 & par_set_0) | 4,1);
	SetPortVal(wPortAddr, (240 & par_set_0 & par_set_clk_0) | 4,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_set_0) | 4,1);}
	SetPortVal(wPortAddr, 240  | ((dwPortVal>>12) & 15),1);
	SetPortVal(wPortAddr, (240 & par_set_clk_0) | ((dwPortVal>>12) & 15),1);
	if (bconf == 1) {SetPortVal(wPortAddr, 240  | ((dwPortVal>>12) & 15),1);}
	// port 5
	SetPortVal(wPortAddr, (240 & par_set_0) | 5,1);
	SetPortVal(wPortAddr, (240 & par_set_0 & par_set_clk_0) | 5,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_set_0) | 5,1);}
	SetPortVal(wPortAddr, 240  | ((dwPortVal>>16) & 15),1);
	SetPortVal(wPortAddr, (240 & par_set_clk_0) | ((dwPortVal>>16) & 15),1);
	SetPortVal(wPortAddr, 240 | ((dwPortVal>>16) & 15),1);

	return true;
}


bool  SetDat(WORD wPortAddr, DWORD dwPortVal, BYTE bconf) //, BYTE bSize)
{
	SetPortVal(wPortAddr, (240 & par_we_0 & par_set_0) | 6,1);
	SetPortVal(wPortAddr, (240 & par_we_0 & par_set_0 & par_set_clk_0) | 6,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_we_0 & par_set_0) | 6,1);}
	SetPortVal(wPortAddr, (240 & par_we_0) | (dwPortVal & 15),1);
	SetPortVal(wPortAddr, (240 & par_we_0 & par_set_clk_0) | (dwPortVal & 15),1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_we_0) | (dwPortVal & 15),1);}
	// port 7
	SetPortVal(wPortAddr, (240 & par_we_0 & par_set_0) | 7,1);
	SetPortVal(wPortAddr, (240 & par_we_0 & par_set_0 & par_set_clk_0) | 7,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_we_0 & par_set_0) | 7,1);}
	SetPortVal(wPortAddr, (240 & par_we_0) | ((dwPortVal>>4) & 15),1);
	SetPortVal(wPortAddr, (240 & par_we_0 & par_set_clk_0) | ((dwPortVal>>4) & 15),1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_we_0) | ((dwPortVal>>4) & 15),1);}
	SetPortVal(wPortAddr, 240 | ((dwPortVal>>4) & 15),1);

	return true;
}

bool  SetNibble(WORD wPortAddr, BYTE PortNr, BYTE PortVal, BYTE bconf)
{
	BYTE	PortValTmp = 0;
	BYTE	PortNrTmp = 0;

	PortValTmp = PortVal & 15;
	PortNrTmp  = PortNr & 15;

	SetPortVal(wPortAddr, (240 & par_set_0) | PortNrTmp,1);
	SetPortVal(wPortAddr, (240 & par_set_0 & par_set_clk_0) | PortNrTmp,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_set_0) | PortNrTmp,1);}
	SetPortVal(wPortAddr, 240  | PortValTmp,1);
	SetPortVal(wPortAddr, (240 & par_set_clk_0) | PortValTmp,1);
	SetPortVal(wPortAddr, 240 | PortValTmp,1);

	return true;
}



bool  GetDat(WORD wPortAddr, DWORD *pdwPortVal, BYTE bconf)
{
	DWORD TmpVal = 0;

	// Port 12 (is a read port)
	SetPortVal(wPortAddr, (240 & par_oe_0 & par_set_0) | 12,1);
	SetPortVal(wPortAddr, (240 & par_oe_0 & par_set_0 & par_set_clk_0) | 12,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_oe_0 & par_set_0) | 12,1);}
	SetPortVal(wPortAddr, (240 & par_oe_0) | 12,1);
	SetPortVal(wPortAddr, (240 & par_oe_0 & par_set_clk_0) | 12,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_oe_0) | 12,1);}
	GetPortVal(wPortAddr + 1, pdwPortVal, 1);
	TmpVal = (*pdwPortVal>>4) & 15;	//get value

	// Port 13 (is a read port)
	SetPortVal(wPortAddr, (240 & par_oe_0 & par_set_0) | 13,1);
	SetPortVal(wPortAddr, (240 & par_oe_0 & par_set_0 & par_set_clk_0) | 13,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_oe_0 & par_set_0) | 13,1);}
	SetPortVal(wPortAddr, (240 & par_oe_0) | 13,1);
	SetPortVal(wPortAddr, (240 & par_oe_0 & par_set_clk_0) | 13,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_oe_0) | 13,1);}
	GetPortVal(wPortAddr + 1, pdwPortVal, 1);
	TmpVal |= *pdwPortVal & 240;	//get value

	SetPortVal(wPortAddr, (240 & par_oe_0) | 13,1);
	SetPortVal(wPortAddr, 240 | 13,1);

	*pdwPortVal = TmpVal ^ 136;		//(invert bit 7 and bit 3 to fix inv. busy line)

	return true;
}



bool  GetConfig(WORD wPortAddr, DWORD *pdwPortVal, BYTE bconf)
{
	DWORD TmpVal = 0;

	//Port 14 (is a read port)
	SetPortVal(wPortAddr, (240 & par_set_0) | 14,1);
	SetPortVal(wPortAddr, (240 & par_set_0 & par_set_clk_0) | 14,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240 & par_set_0) | 14,1);}
	SetPortVal(wPortAddr, (240 ) | 14,1);
	SetPortVal(wPortAddr, (240 & par_set_clk_0) | 14,1);
	SetPortVal(wPortAddr, 240 | 14,1);
	GetPortVal(wPortAddr + 1, pdwPortVal, 1);
	TmpVal = (*pdwPortVal>>4) & 15;

	*pdwPortVal = TmpVal ^ 8;					//(invert bit 3 to fix inv. busy line)

	return true;
}


bool  GetHWVer(WORD wPortAddr, DWORD *pdwPortVal, BYTE bconf)
{
	DWORD TmpVal = 0;

	//Port 15 (is a read port)
	SetPortVal(wPortAddr, (240  & par_set_0) | 15,1);
	SetPortVal(wPortAddr, (240  & par_set_0 & par_set_clk_0) | 15,1);
	if (bconf == 1) {SetPortVal(wPortAddr, (240  & par_set_0) | 15,1);}
	SetPortVal(wPortAddr, (240 ) | 15,1);
	SetPortVal(wPortAddr, (240  & par_set_clk_0) | 15,1);
	SetPortVal(wPortAddr, 240 | 15,1);
	GetPortVal(wPortAddr + 1, pdwPortVal, 1);
	TmpVal = (*pdwPortVal>>4) & 15;

	*pdwPortVal = TmpVal ^ 8;					//(invert bit 3 to fix inv. busy line)
	return true;
}
