#ifndef jaxstream_h
#define jaxstream_h

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdarg.h>
#include <dirent.h>
#include <pwd.h>
#include <grp.h>
#include <errno.h>
#include <time.h>
#include <signal.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>

#ifndef SHUT_RDWR
#define SHUT_RDWR 2
#endif

#define debug(argv...) { \
	if(do_debug) \
		fprintf(stderr,argv); \
}
#define log(argv...) { \
	if(lf) { \
		time_t t=time(NULL); \
		char date[81]; \
		strncpy(date,ctime(&t),80); \
		date[80]=0; \
		strip(date,"\n\r "); \
		fprintf(lf,"%s [%d] ",date, getpid()); \
		fprintf(lf,argv); \
		fflush(lf); \
	} \
}

////////////////////////////////////////////////////////////////////////////////

#ifndef VERSION
#define VERSION "ic20"
#endif

#define XS_IP "0.0.0.0"
#define XS_PORT 1400
#define XS_USER "nobody"
#define XS_GROUP "nobody"
#define XS_CFGFILE "/etc/jaxstream.cfg"
#define XS_LOGFILE "/var/log/jaxstream.log"
#define XS_PIDFILE "/var/run/jaxstream.pid"

#define XS_SLEN 32
#define XS_LEN 4096

#define XS_HELLO0 "HELLO XSTREAM 6.0"
#define XS_HELLO1 "HELLO XBOX!"

#define XS_SHARES0 "<SHARES>\n"
#define XS_ITEM0 "<ITEM><ATTRIB>"
#define XS_ITEM1 "</ATTRIB><PATH>"
#define XS_ITEM2 "</PATH></ITEM>\n"
#define XS_SHARES1 "</SHARES>"

#define XS_ATTR_DIR 0x10
#define XS_ATTR_FILE 0x80
#define XS_ATTR_HAVE_SRT 0x08
#define XS_ATTR_HAVE_TBN 0x04

#define XS_CAT_ROOT "$ROOT$"
#define XS_CAT_CURRENT '$'
#define XS_CAT_BACK "BACK"

//							"                                "
#define XS_ERROR			"-1 ERROR                        "
#define XS_ERROR_UNKNOWN	"-1 UNKNOWN ERROR                "
#define XS_ERROR_OPEN		"-1 UNABLE TO OPEN               "
#define XS_ERROR_READ		"-1 READ FAILED                  "
#define XS_ERROR_TELL		"-1 TELL FAILED                  "

typedef enum {
	XS_CLIENT_VALID=0x01,
	XS_CLIENT_PLAYING=0x02
} XSClientState;

struct XSClient;
typedef int (*XSCmdFunc)(struct XSClient *client, char *line);
typedef int (*XSRunFunc)(struct XSClient *client);

typedef struct XSCmd {
	char *str;
	XSCmdFunc func;
} XSCmd;

typedef struct XSClient {
	struct sockaddr_in addr;	// from address:port
	int sock;					// client socket
	int state; 					// XSClientState flags
	char cmd[XS_LEN];			// last recv'd command
	char fname[XS_LEN];			// opened filename
	off_t len;					// file length
	off_t pos;					// file position
	int fd;						// file descriptor of opened file
	XSRunFunc run;				// run function
} XSClient;

typedef enum {
	CFG_INVALID=0,
	CFG_SHORT=2,
	CFG_STRING=3,
	CFG_INT=4
} CfgType;

typedef struct {
	char *opt;
	CfgType type;
	void *var;
	int len;
	int onhup;
} XSCfg;

char *fdgets(char *str, int max_len, int fd);
int fdNprintf(int fd, int N, char *format, ...);
int fdprintf(int fd, char *format, ...);
int mprintf(char **dest, char *format, ...);
char *strip(char *str, char *remove);

void readcfg(int inhup);
	
void add_client(int sock, struct sockaddr_in *addr);
void free_xsclient(XSClient *c);
void remove_client_ptr(XSClient *c);
void remove_client(int i);

int xs_cat(struct XSClient *client, char *line);
int xs_back(struct XSClient *client, char *line);
int xs_open(struct XSClient *client, char *line);
int xs_read(struct XSClient *client, char *line);
int xs_tell(struct XSClient *client, char *line);
int xs_clse(struct XSClient *client, char *line);
int xs_dbug(struct XSClient *client, char *line);
int xs_unkn(struct XSClient *client, char *line);

int client_run_hello(XSClient *c);
int client_run_xstream_60(XSClient *c);

extern XSCmd cmds[];
extern int done;
extern XSClient *clients;
extern int num_clients;
extern int do_debug;

#endif
