package com.superhac.JXBStreamer.Gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import com.superhac.JXBStreamer.Core.XBMSPServer;

public class StatusPanel {

	private JPanel jPanel = null;  //  @jve:decl-index=0:visual-constraint="274,69"
	private JScrollPane jScrollPane = null;
	private JTable jTable = null;

	
	ConnectionStatusTabMod model;
	//private XBMSPServer server;
	private JPanel jPanel1 = null;
	private JLabel jLabel = null;
	
	
	public StatusPanel(XBMSPServer server)
	{
		//this.server = server;
		model = new ConnectionStatusTabMod(server); 
	}
	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	public JPanel getJPanel() {
		if (jPanel == null) {
			jPanel = new JPanel();
			jPanel.setBackground(java.awt.Color.black);
			jPanel.setLayout(new BorderLayout());
			jPanel.setVisible(false);
			jPanel.add(getJScrollPane(), java.awt.BorderLayout.CENTER);
			jPanel.add(getJPanel1(), java.awt.BorderLayout.NORTH);
			jTable.setModel(model);
			
		}
		return jPanel;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setPreferredSize(new java.awt.Dimension(800,600));
			jScrollPane.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_NEVER);
			jScrollPane.setBackground(java.awt.Color.black);
			jScrollPane.setForeground(new java.awt.Color(116,181,33));
//			 this is another color hack to get the scroll pane thats not filled by jtable to be black
			jScrollPane.getViewport().setBackground(Color.black); 
			jScrollPane.setViewportView(getJTable());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jTable	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJTable() {
		if (jTable == null) {
			jTable = new JTable();
			jTable.setBackground(java.awt.Color.black);
			jTable.setForeground(new java.awt.Color(116,181,33));
//			 the table header colors need to be set!  it doesnt use the default renderer
			jTable.getTableHeader().setBackground(java.awt.Color.black);
			jTable.getTableHeader().setForeground(new java.awt.Color(116, 181, 33));
			jTable.setDefaultRenderer(Object.class,
					new DefaultTableCellRenderer() {
				final static long serialVersionUID = 453499534L; 

				public Component getTableCellRendererComponent(JTable table, Object
						value, boolean isSelected, boolean hasFocus, int row, int col)
						    {
						        

						        // the background must be red...
						        setBackground(Color.black);

						        // ...and the text itself must be yellow
						        setForeground(new java.awt.Color(116, 181, 33));

						        // perform the default actions to the cell.
						        return super.getTableCellRendererComponent(table, value, isSelected,
						hasFocus, row, col);
						    }
					});
			
		}
		return jTable;
	}

	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel1() {
		if (jPanel1 == null) {
			jLabel = new JLabel();
			jLabel.setText("Connection Monitor");
			jLabel.setForeground(new java.awt.Color(116, 181, 33));
			jLabel.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 18));
			jLabel.setBackground(new java.awt.Color(238, 238, 238));
			jPanel1 = new JPanel();
			jPanel1.setBackground(java.awt.Color.black);
			jPanel1.add(jLabel, null);
		}
		return jPanel1;
	}

}
