package com.superhac.JXBStreamer.Core;

/**
 * Contains connected client status varibles like IP address, transfer rate,
 * etc... Each client that is connected will be represented by one ConnectedClientStatus
 * object.  A arrayList of these objects will be contained withing a ServerStatus
 * object.
 * <p>
 * <p>
 * More information can be found at <a
 * href="http://www.superhac.com">Superhac.com</a>
 * 
 * @author Steven Scott (superhac007@gmail.com)
 */
public class ConnectedClientStatus {

	private String sourceIP;

	private String clientVersion;

	private int lastClientCommand;

	private int openFileHandlers;

	private int openDirectoryHandlers;

	private long transferedBytesSec;

	protected ConnectedClientStatus(String sourceIP, String clientVersion,
			int lastClientCommand, int openFileHandlers,
			int openDirectoryHandlers, long transferedBytesSec) {

		this.sourceIP = sourceIP;
		this.clientVersion = clientVersion;
		this.lastClientCommand = lastClientCommand;
		this.openFileHandlers = openFileHandlers;
		this.openDirectoryHandlers = openDirectoryHandlers;
		this.transferedBytesSec = transferedBytesSec;
	}

	/**
	 * Get the clients XBMSP Protocol version
	 * 
	 * @return The clients XBMSP protocol version.
	 */
	public String getClientVersion() {
		return clientVersion;
	}

	/**
	 * Gets the clients last XBMSP command sent to the server.
	 * 
	 * @return The last client issued command
	 */
	public String getLastClientCommand() {

		switch (lastClientCommand) {
		case XBMSPEncoderDecoder.XBMSP_PACKET_SETCWD: // change dir
			return "<XBMSP_PACKET_SETCWD Decoded>";

		case XBMSPEncoderDecoder.XBMSP_PACKET_UPCWD:
			return "<XBMSP_PACKET_UPCWD>";

		case XBMSPEncoderDecoder.XBMSP_PACKET_FILELIST_READ:
			return "<XBMSP_PACKET_FILELIST_READ>";

		case XBMSPEncoderDecoder.XBMSP_PACKET_FILE_INFO:
			return "<XBMSP_PACKET_FILE_INFO>";

		case XBMSPEncoderDecoder.XBMSP_PACKET_FILE_OPEN:
			return "<XBMSP_PACKET_FILE_OPEN>";

		case XBMSPEncoderDecoder.XBMSP_PACKET_FILE_READ:
			return "<XBMSP_PACKET_FILE_READ>";

		case XBMSPEncoderDecoder.XBMSP_PACKET_FILE_SEEK:
			return "<XBMSP_PACKET_FILE_SEEK>";

		case XBMSPEncoderDecoder.XBMSP_PACKET_CLOSE:
			return "<XBMSP_PACKET_CLOSE>";

		case XBMSPEncoderDecoder.XBMSP_PACKET_SET_CONFIGURATION_OPTION:
			return "<XBMSP_PACKET_SET_CONFIGURATION_OPTION>";

		case XBMSPEncoderDecoder.XBMSP_PACKET_AUTHENTICATION_INIT:
			return "<XBMSP_PACKET_AUTHENTICATION_INIT>";

		case XBMSPEncoderDecoder.XBMSP_PACKET_AUTHENTICATE:
			return "<XBMSP_PACKET_AUTHENTICATE>";

		default:
			return "Unknown Command";

		}

	}

	/**
	 * The XBMSP protcol uses handles for associating File and Directory names.
	 * This is like a reference number. A client asks for a handle to a file or
	 * a directory and the server provides it one. Any request for services of
	 * the file or directory will use the handle identifier(int). A client can
	 * have many handles opened at once.
	 * 
	 * @return The number of open DIRECTORY handlers
	 */
	public int getOpenDirectoryHandlers() {
		return openDirectoryHandlers;
	}

	/**
	 * The XBMSP protcol uses handles for associating File and Directory names.
	 * This is like a reference number. A client asks for a handle to a file or
	 * a directory and the server provides it one. Any request for services of
	 * the file or directory will use the handle identifier(int). A client can
	 * have many handles opened at once.
	 * 
	 * @return The number of open File handlers
	 */
	public int getOpenFileHandlers() {
		return openFileHandlers;
	}

	/**
	 * Gets the source IP address of the client.
	 * 
	 * @return The source IP address of the client.
	 */
	public String getSourceIP() {
		return sourceIP;
	}

	/**
	 * Gets the number of bytes transfered per second. If a client is streaming
	 * content this will return the rate at which the server is streaming it.
	 * (BYTES per second) If you want KB then divide the numner by 1000.....
	 * 
	 * @return The number of BYTES transfered per second.
	 */
	public long getTransferedBytesSec() {
		return transferedBytesSec;
	}

}
