package com.superhac.JXBStreamer.Gui;

import java.awt.BorderLayout;
import java.io.File;
import java.util.ArrayList;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.UIManager;

import com.superhac.JXBStreamer.Core.Debug;
import com.superhac.JXBStreamer.Core.XBMSPServer;

public class Main {

	private JFrame mainJFrame = null; // @jve:decl-index=0:visual-constraint="326,89"

	private JPanel jContentPane = null;

	private JMenuBar jJMenuBar = null;

	private JMenu jMenu = null;

	private JMenu jMenu1 = null;

	private JMenu jMenu2 = null;

	private JMenuItem jMenuItem1 = null;

	private JMenuItem jMenuItem2 = null;

	private JMenuItem jMenuItem3 = null;

	private JMenuItem jMenuItem4 = null;

	private JMenuItem jMenuItem5 = null;

	private JMenuItem jMenuItem6 = null;

	private XBMSPServer server;

	JPanel statusPanel;

	AboutWindow aboutWindow;

	SharePanel sharePanel;

	MainStatusBar mainStatusPanel;

	SaveAndLoadSettings settings;

	private JMenu jMenu3 = null;

	private JMenuItem jMenuItem7 = null;

	private JMenuItem jMenuItem8 = null;

	public Main() {
		this.server = new XBMSPServer();

		
		// load settings
		loadSettings();

		initAboutWindow();
		initSharePanel();
		
		
	}

	/**
	 * This method initializes jFrame
	 * 
	 * @return javax.swing.JFrame
	 */
	private JFrame getJFrame() {
		if (mainJFrame == null) {
			mainJFrame = new JFrame();
			mainJFrame.setPreferredSize(new java.awt.Dimension(810, 610));
			mainJFrame.setMinimumSize(new java.awt.Dimension(800, 600));
			mainJFrame.setTitle("JXBStreamer");
			mainJFrame
					.setDefaultCloseOperation(javax.swing.JFrame.EXIT_ON_CLOSE);
			mainJFrame.setContentPane(getJContentPane());
			mainJFrame.setJMenuBar(getJJMenuBar());
			mainJFrame.setLocationRelativeTo(null);

			// add status bar
			mainStatusPanel = new MainStatusBar(server);
			mainJFrame.setBackground(java.awt.Color.black);
			mainJFrame.setForeground(new java.awt.Color(116,181,33));
			
			mainJFrame.getContentPane().add(mainStatusPanel.getJPanel(),
					BorderLayout.SOUTH);

			// init statusPanel
			initConnectionStatusPanel();

			// center frame on screen
			mainJFrame.pack();
			mainJFrame.setLocationRelativeTo(null);

			// init aboutPanel
			initAboutWindow();
			
			// show share panel first
			displaySharePanel();

		}
		return mainJFrame;
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.setPreferredSize(new java.awt.Dimension(800, 600));
			jContentPane.setBackground(java.awt.Color.black);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jJMenuBar
	 * 
	 * @return javax.swing.JMenuBar
	 */
	private JMenuBar getJJMenuBar() {
		if (jJMenuBar == null) {
			jJMenuBar = new JMenuBar();
			jJMenuBar.setBackground(java.awt.Color.black);
			jJMenuBar.add(getJMenu());
			jJMenuBar.add(getJMenu3());
			jJMenuBar.add(getJMenu1());
			jJMenuBar.add(getJMenu2());

		}
		return jJMenuBar;
	}

	/**
	 * This method initializes jMenu
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getJMenu() {
		if (jMenu == null) {
			jMenu = new JMenu();
			jMenu.setText("File");
			jMenu.setForeground(new java.awt.Color(116,181,33));
			jMenu.setBackground(java.awt.Color.black);
			jMenu.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 14));
			jMenu.add(getJMenuItem5());
			jMenu.add(getJMenuItem6());
		}
		return jMenu;
	}

	/**
	 * This method initializes jMenu1
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getJMenu1() {
		if (jMenu1 == null) {
			jMenu1 = new JMenu();
			jMenu1.setText("Server");
			jMenu1.setBackground(java.awt.Color.black);
			jMenu1.setForeground(new java.awt.Color(116,181,33));
			jMenu1.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 14));
			jMenu1.add(getJMenuItem3());
			jMenu1.add(getJMenuItem4());
		}
		return jMenu1;
	}

	/**
	 * This method initializes jMenu2
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getJMenu2() {
		if (jMenu2 == null) {
			jMenu2 = new JMenu();
			jMenu2.setText("Help");
			jMenu2.setBackground(java.awt.Color.black);
			jMenu2.setForeground(new java.awt.Color(116,181,33));
			jMenu2.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 14));
			jMenu2.add(getJMenuItem1());
			jMenu2.add(getJMenuItem2());
		}
		return jMenu2;
	}

	/**
	 * This method initializes jMenuItem1
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem1() {
		if (jMenuItem1 == null) {
			jMenuItem1 = new JMenuItem();
			jMenuItem1.setText("Debug");
			jMenuItem1.setForeground(new java.awt.Color(116,181,33));
			jMenuItem1.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 12));
			jMenuItem1.setBackground(java.awt.Color.black);
			jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					// debug window
					// set the debugger to true
					// com.superhac.XXXXXX.CORE.Debug.Debug
					Debug.debug = true;
					// open the window
					new DebugWindow().getJFrame().setVisible(true);

				}
			});
		}
		return jMenuItem1;
	}

	/**
	 * This method initializes jMenuItem2
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem2() {
		if (jMenuItem2 == null) {
			jMenuItem2 = new JMenuItem();
			jMenuItem2.setText("About");
			jMenuItem2.setForeground(new java.awt.Color(116,181,33));
			jMenuItem2.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 12));
			jMenuItem2.setBackground(java.awt.Color.black);
			jMenuItem2.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					aboutWindow.getJFrame(mainJFrame).setVisible(true);
				}
			});
		}
		return jMenuItem2;
	}

	/**
	 * This method initializes jMenuItem3
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem3() {
		if (jMenuItem3 == null) {
			jMenuItem3 = new JMenuItem();
			jMenuItem3.setText("Start/Stop");
			jMenuItem3.setBackground(java.awt.Color.black);
			jMenuItem3.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 12));
			jMenuItem3.setForeground(new java.awt.Color(116,181,33));
			jMenuItem3.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					// check if server is running?
					if (server.isServerRunning()) {
						server.stopServer();
						hideConnectionStatusPane();

					} else // start it
					{

						
						// Set all the server settings! Then start it
						server.setVirtualRoot((ArrayList<File>) settings.shares
								.clone());
						server.setAutoDiscoveryEnabled(settings.enableAutoDiscovery);
						server.setPort(settings.portNumber);

						server.startServer();

						// load the connection status panel
						displayConnectionStatusPane();

					}

				}
			});
		}
		return jMenuItem3;
	}

	/**
	 * This method initializes jMenuItem4
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem4() {
		if (jMenuItem4 == null) {
			jMenuItem4 = new JMenuItem();
			jMenuItem4.setText("Settings");
			jMenuItem4.setBackground(java.awt.Color.black);
			jMenuItem4.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 12));
			jMenuItem4.setForeground(new java.awt.Color(116,181,33));
			jMenuItem4.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {

					// SettingsWindow sett = new SettingsWindow();
					SettingsWindow sett = new SettingsWindow(String
							.valueOf(settings.portNumber), settings.enableAutoDiscovery);

					JDialog settingss = sett.getJDialog(mainJFrame);
					settingss.setVisible(true);

					
					if (sett.isResetServer()) {
						// update the settings
						
						settings.portNumber = sett.getPort();
						settings.enableAutoDiscovery = sett.isAutoDiscoveryEnabled();
					}

				}
			});
		}
		return jMenuItem4;
	}

	/**
	 * This method initializes jMenuItem5
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem5() {
		if (jMenuItem5 == null) {
			jMenuItem5 = new JMenuItem();
			jMenuItem5.setText("Save Settings");
			jMenuItem5.setBackground(java.awt.Color.black);
			jMenuItem5.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 12));
			jMenuItem5.setForeground(new java.awt.Color(116,181,33));
			jMenuItem5.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					saveSettings();
				}
			});
		}
		return jMenuItem5;
	}

	/**
	 * This method initializes jMenuItem6
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem6() {
		if (jMenuItem6 == null) {
			jMenuItem6 = new JMenuItem();
			jMenuItem6.setText("Exit");
			jMenuItem6.setBackground(java.awt.Color.black);
			jMenuItem6.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 12));
			jMenuItem6.setForeground(new java.awt.Color(116,181,33));
			jMenuItem6.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					if (server.isServerRunning())
						server.stopServer();

					System.exit(0);
				}
			});
		}
		return jMenuItem6;
	}

	public void hideConnectionStatusPane() {
		if (statusPanel.isVisible()) {
			statusPanel.setVisible(false);
			mainJFrame.getContentPane().removeAll();
			mainJFrame.getContentPane().add(mainStatusPanel.getJPanel(),
					BorderLayout.SOUTH);
			mainJFrame.repaint();
			mainJFrame.pack();
		} else
			return;
	}

	public void displayConnectionStatusPane() {
		if (statusPanel.isVisible())
			return;
		else {
			mainJFrame.getContentPane().removeAll();
			sharePanel.getJPanel().setVisible(false);
			mainJFrame.getContentPane().add(mainStatusPanel.getJPanel(),
					BorderLayout.SOUTH);
			mainJFrame.getContentPane().add(statusPanel, BorderLayout.CENTER);
			statusPanel.setVisible(true);
			mainStatusPanel.getJPanel().setVisible(true);
			mainJFrame.repaint();
			mainJFrame.pack();
		}

	}

	public void displaySharePanel() {
		JPanel panel = sharePanel.getJPanel();
		if (panel.isVisible())
			return;
		else {
			mainJFrame.getContentPane().removeAll();
			statusPanel.setVisible(false);
			mainJFrame.getContentPane().add(mainStatusPanel.getJPanel(),
					BorderLayout.SOUTH);
			mainJFrame.getContentPane().add(panel, BorderLayout.CENTER);
			panel.setVisible(true);
			mainJFrame.repaint();
			mainJFrame.pack();
		}
	}

	public void initSharePanel() {
		if (sharePanel == null)
			sharePanel = new SharePanel(settings.shares);

		sharePanel.getJPanel().setVisible(false);
	}

	public void initConnectionStatusPanel() {
		if (statusPanel == null)
			statusPanel = new StatusPanel(server).getJPanel();

		statusPanel.setVisible(false);
	}

	public void initAboutWindow() {
		aboutWindow = new AboutWindow();
		// aboutWindow = awindow.getJFrame(mainJFrame);
	}

	/**
	 * This method initializes jMenu3
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getJMenu3() {
		if (jMenu3 == null) {
			jMenu3 = new JMenu();
			jMenu3.setText("View");
			jMenu3.setBackground(java.awt.Color.black);
			jMenu3.setForeground(new java.awt.Color(116,181,33));
			jMenu3.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 14));
			jMenu3.add(getJMenuItem7());
			jMenu3.add(getJMenuItem8());
		}
		return jMenu3;
	}

	/**
	 * This method initializes jMenuItem7
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem7() {
		if (jMenuItem7 == null) {
			jMenuItem7 = new JMenuItem();
			jMenuItem7.setText("Connections");
			jMenuItem7.setBackground(java.awt.Color.black);
			jMenuItem7.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 12));
			jMenuItem7.setForeground(new java.awt.Color(116,181,33));
			jMenuItem7.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {

					displayConnectionStatusPane();
				}
			});
		}
		return jMenuItem7;
	}

	/**
	 * This method initializes jMenuItem8
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem8() {
		if (jMenuItem8 == null) {
			jMenuItem8 = new JMenuItem();
			jMenuItem8.setText("Shares");
			jMenuItem8.setForeground(new java.awt.Color(116,181,33));
			jMenuItem8.setFont(new java.awt.Font("Samanata", java.awt.Font.BOLD, 12));
			jMenuItem8.setBackground(java.awt.Color.black);
			jMenuItem8.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {

					// SHARE PANEL!

					displaySharePanel();
					System.out.println("share panel");

				}
			});
		}
		return jMenuItem8;
	}

	public void loadSettings() {
		settings = new SaveAndLoadSettings();
		settings = settings.loadSettings();

		// could not load... start with default
		if (settings == null) {
			settings = new SaveAndLoadSettings();
		}

	}

	public void saveSettings() {
		settings.saveSettings();
	}

	public static void main(String[] args) {

		
		// launch the splash screen
		new Thread(new Runnable() {
		    public void run() {
		        try {
		        	JWindow splash = new SplashScreen().getJWindow();
		    		splash.setVisible(true);
		    		Thread.sleep(3000);
					splash.setVisible(false);
		        } catch (InterruptedException ex) {
		        }
		    }
		}).start();
		
		try {
	        
    		Thread.sleep(1000); // a little extra delay before the main window
			
        } catch (InterruptedException ex) {
        }
		
//		 Set up UI defaults
		UIManager.getDefaults().put("Menu.selectionBackground", new java.awt.Color(116, 181, 33));
		UIManager.getDefaults().put("MenuItem.selectionBackground", new java.awt.Color(116, 181, 33)); 
		UIManager.getDefaults().put("Tree.selectionBackground", new java.awt.Color(116, 181, 33));
		UIManager.getDefaults().put("Table.selectionBackground", new java.awt.Color(116, 181, 33));
		UIManager.getDefaults().put("ComboBox.selectionBackground", new java.awt.Color(116, 181, 33));
		
        // launch the main window
        new Main().getJFrame().setVisible(true);
        
	}
}
