package com.superhac.JXBStreamer.Gui;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

import javax.swing.table.AbstractTableModel;

import com.superhac.JXBStreamer.Core.ConnectedClientStatus;
import com.superhac.JXBStreamer.Core.ServerStatus;
import com.superhac.JXBStreamer.Core.XBMSPServer;

public class ConnectionStatusTabMod extends AbstractTableModel {
	
	final static long serialVersionUID = 4534534L; 

	   ArrayList<ConnectedClientStatus> clients;
	   XBMSPServer server;
	   Timer timer;
	   
	    public String[] colNames = {"IP", "LastCommand", "Dir Handles", "File Handles", "Transfer Rate", "Client Version"};

	    /** Creates a new instance of IncommingConnTableModel */
	    public ConnectionStatusTabMod(XBMSPServer server) {
	        super();

	        this.server = server;
	        ServerStatus ss = server.getServerStatus();
	        clients = ss.getClients(); 
	        
	        // fire a table update every second
	        timer = new Timer();
	        timer.scheduleAtFixedRate(new RemindTask(this), 0, 1000);
	        
	    }

	    public String getColumnName(int col) {
	        return colNames[col].toString();
	    }
	    public int getRowCount() { return clients.size(); }
	    public int getColumnCount() { return colNames.length; }
	    public Object getValueAt(int row, int col) {

	        ConnectedClientStatus client = clients.get(row);

	        switch (col) {

	            case 0:
	                return client.getSourceIP();
	            case 1:
	                return client.getLastClientCommand();
	            case 2:
	            	return client.getOpenDirectoryHandlers();
	            case 3:
	            	return client.getOpenFileHandlers();
	            case 4:
	            	long bytes;
	            		if ((bytes = client.getTransferedBytesSec()) != 0 )
	                    	return (bytes / 1000)+ "/KBps";
	            		else
	            			return "0 KBps";
	            	
	            case 5:
	            	return client.getClientVersion();
	        }

	        return "";
	    }
	    public boolean isCellEditable(int row, int col)
	        { return false; }
	    
	    public void update()
		{
			ServerStatus ss = server.getServerStatus();
	        clients = ss.getClients(); 
	        
	        this.fireTableDataChanged();
		}
	    
}
	
	    class RemindTask extends TimerTask {

	    	boolean keepRunning = true;
	    	ConnectionStatusTabMod caller;

	        RemindTask(ConnectionStatusTabMod caller) {
	        	this.caller = caller;
	           
	        }

	        public void run() {

	        	
	        		caller.update();	        

	        	}


	    }  
	    


