{----------------------------------------------------------------------}
{ Author  : Remco Sonnema                                              }
{ Date    : December 1997                                              }
{ What    : This is for loading mp3 information with buffer!           }
{           The buffer is for access managment of the mp3's            }
{           Less is better :))                                         }
{ Whatfor : This unit is used in Mp3Dbase and Mp3VotePlayer by Me      }
{           and RelaX                                                  }
{ Licence : Released under GPL                                         }
{----------------------------------------------------------------------}
unit ump3object;
interface
uses
  Classes;

Type

  TMp3Object=class(TComponent)
  private
    FMp3File: String;
    FMp3FileShort: String;
    FVersion:byte;        {2 bytes}
    FLayer:byte;          {2 bits}
    FBitrate:byte;        {4 bits}
    FSampfreq:byte;       {2 bits}
    fmode:byte;           {2 Bits}
    FTagsongname:String;
    FTagArtist:String;
    FTagAlbum:String;
    FTagYear:String;
    FTagComment:String;
    FTaggenre:Longint;
    FTime:longint;
    FTimeString:String;
    FSize:Longint;
    FSizeString:String;
    FmpegTypeString:String;
    FlayerString:String;
    FbitrateString:String;
    FSampleRateString:String;
    FChannelModeString:String;
    procedure SetMp3File(const Value: String);
  public
    property Mp3File:String read FMp3File write SetMp3File;
    property Mp3FileShort:String read FMp3FileShort;
    Property Size:String Read FSizeString;
    Property BitRate:String Read FBitRateString;
    Property MpegType:String Read FmpegTypeString;
    Property Layer:String Read FlayerString;
    Property ChannelMode:String Read FChannelModeString;
    Property Time:String Read FTimeString;
  end;

implementation
uses
  Forms,
  sysutils;

Const
  {Local File Access}
  fmReadOnly  = $00;
  fmWriteOnly = $01;
  fmReadWrite = $02;
  {Share File Access}
  fmDenyAll   = $10;
  fmDenyWrite = $20;
  fmDenyRead  = $30;
  fmDenyNone  = $40;
  {Inheritance}
  fmNoInherit = $70;

const bg=0;
      mode_names:array[bg+0..bg+4] of string[9]=('stereo','j-stereo','dual-ch','single-ch','multi-ch');
      layer_names:array[bg+0..bg+2] of string[3]=('I', 'II', 'III');
      version_names:array[bg+0..bg+2] of string[10]=('MPEG-1','MPEG-2 LSF','MPEG-2.5');
      version_nums:array[bg+0..bg+2] of string[3]=('1','2','2.5');

const bitrates:Array [bg+0..bg+2] of array[bg+0..bg+2] of array[bg+0..bg+14] of word=
{Mpeg 1}    {Layer I}  (((0,32,64,96,128,160,192,224,256,288,320,352,384,416,448),
            {Layer II}   (0,32,48,56,64,80,96,112,128,160,192,224,256,320,384),
            {Layer III}  (0,32,40,48,56,64,80,96,112,128,160,192,224,256,320)),

{Mpeg-2 Lsf}{Layer I}   ((0,32,48,56,64,80,96,112,128,144,160,176,192,224,256),
            {Layer II}   (0, 8,16,24,32,40,48, 56, 64, 80, 96,112,128,144,160),
            {Layer III}  (0, 8,16,24,32,40,48, 56, 64, 80, 96,112,128,144,160)),

{Mpeg-2.5}  {Layer I}   ((0,32,48,56,64,80,96,112,128,144,160,176,192,224,256),
            {Layer II}   (0,8,16,24,32,40,48,56,64,80,96,112,128,144,160),
            {Layer III}  (0,8,16,24,32,40,48,56,64,80,96,112,128,144,160)));


      sfreq:array[bg+0..bg+2]of array[bg+0..bg+3]of Word=
{mpeg 1}    ((44100,48000,32000,0),
{Mpeg-2 Lsf} (22050,24000,16000,0),
{Mpeg-2.5}   (11025, 8000, 8000,0));

type buf=array[0..4] of byte;
     taginfo=record
           id:array [1..3] of char;
           Songname:array [1..30] of char;
           Artist:array [1..30] of char;
           Album:array [1..30] of char;
           Year:array [1..4] of char;
           Comment:array [1..30] of char;
           Genre:byte;
         end;

Function IsBitSet(Var INByte:Byte;Bit2Test:Byte):Boolean;
begin
  if (Bit2Test in[0..7])then IsBitSet:=((INByte and(1shl Bit2Test))<>0)
                        else isbitset:=false;
end;

function LeadingZero(w:Word) : String;
var s:String;
begin
  Str(w:0,s);
  if Length(s)=1 then s:='0'+s;
  LeadingZero := s;
end;



procedure TMp3Object.SetMp3File(const Value: String);
var buffer:buf;
    tag:taginfo;
    f:file;
    z,result:longint;
    t:string[255];
    diri:tsearchrec;
begin
  FMp3File := UpperCase(Value);

  if findfirst(value,faanyfile,diri)<>0 then
    abort;
  FMp3FileShort:=Diri.Name;

  FSize:=diri.Size;
  FSizeString:=inttostr(Diri.size);
  FileMode:=fmReadonly+fmDenyNone;
  system.assign(f,Value);
  system.reset(f,1);

  z:=0;
  result:=sizeof(buffer);
  buffer[0]:=0;
{seeking valid header (upto 20480 bytes)}
  while (z<20480) and (buffer[0]<>255) and (result=sizeof(buffer))do
    begin
      seek(f,z);
      inc(z);
      system.blockRead(f,buffer,sizeof(buffer),result);
    end;
{Reading TagRecord}
  system.seek(f,filesize(f)-128);
  system.blockread(f,tag,sizeof(tag));
  system.close(f);
  {$I+}
  if ioresult<>0 then;
  if buffer[0]<>255 then
    begin
      FTimeString:='';
      FmpegTypeString:='';
      FLayerString:='';
      FbitrateString:='';
      FSampleRateString:='';
      FChannelModeString:='';
    end
  else
    begin
      Flayer:=0;
      if isbitset(buffer[1],1) then Flayer:=1;
      if isbitset(buffer[1],2) then Flayer:=Flayer+2;
      Flayer:=4-Flayer;
      Fbitrate:=0;
      if isbitset(buffer[2],4) then Fbitrate:=1;
      if isbitset(buffer[2],5) then Fbitrate:=Fbitrate+2;
      if isbitset(buffer[2],6) then Fbitrate:=Fbitrate+4;
      if isbitset(buffer[2],7) then Fbitrate:=Fbitrate+8;
      Fsampfreq:=0;
      if isbitset(buffer[2],2) then Fsampfreq:=1;
      if isbitset(buffer[2],3) then Fsampfreq:=Fsampfreq+2;
      Fversion:=0;
      if isbitset(buffer[1],2) then Fversion:=1;
      if isbitset(buffer[1],3) then Fversion:=Fversion+2;
      case Fversion of
        2:Fversion:=0;
        3:Fversion:=1;
        0:Fversion:=2;
       else Fversion:=4; {no mpeg file?}
      end;

      Fmode:=0;
      if isbitset(buffer[3],6) then Fmode:=1;
      if isbitset(buffer[3],7) then Fmode:=Fmode+2;
      if bitrates[Fversion][Flayer - 1][Fbitrate] <>0 then
        begin
          Ftime:=Fsize div (bitrates[Fversion][Flayer - 1][Fbitrate]*125);
          FTimeString:=inttostr(Ftime div 60)+' : '+leadingzero(Ftime mod 60);
        end
      else
        FTimeString:='';

      FmpegTypeString:=version_names[Fversion];
      FlayerString:=layer_names[Flayer-1];
      FbitrateString:=Inttostr(bitrates[Fversion][Flayer - 1][Fbitrate]);
      FSampleRateString:=Inttostr(sfreq[Fversion][Fsampfreq]);
      FChannelModeString:=mode_names[Fmode];
    end;
  if tag.id<>'TAG' then
    begin
      FTagsongname:='';
      FTagArtist:='';
      FTagAlbum:='';
      FTagYear:='';
      FTagComment:='';;
      FTaggenre:=80;
    end
  else
    begin
      t:=tag.songname;
      while (length(t)>0) and (t[length(t)]=' ') do system.delete(t,length(t),1);
      FTagsongname:=t;

      t:=tag.artist;
      while (length(t)>0) and (t[length(t)]=' ') do system.delete(t,length(t),1);
      FTagArtist:=t;

      t:=tag.album;
      while (length(t)>0) and (t[length(t)]=' ') do system.delete(t,length(t),1);
      FTagAlbum:=t;

      t:=tag.year;
      while (length(t)>0) and (t[length(t)]=' ') do system.delete(t,length(t),1);
      FTagYear:=t;

      t:=tag.comment;
      while (length(t)>0) and (t[length(t)]=' ') do system.delete(t,length(t),1);
      FTagComment:=t;

      FTaggenre:=tag.genre;
      if Ftaggenre>80 then Ftaggenre:=80;
    end;

end;




end.

