unit IdServerIOHandlerSocket;

interface

Uses
  SysUtils, IdGlobal, IdServerIOHandler, IdStackConsts, IdIOHandler, IdIOHandlerSocket;

type
  TIdServerIOHandlerSocket = class(TIdServerIOHandler)
  public
    procedure Init; override;
    function Accept(ASocket: TIdStackSocketHandle): TIdIOHandler; override;
  end;

implementation

{ TIdServerIOHandlerSocket }

procedure TIdServerIOHandlerSocket.Init;
begin
  //
end;

function TIdServerIOHandlerSocket.Accept(ASocket: TIdStackSocketHandle): TIdIOHandler;
Var
  LIOHandler: TIdIOHandlerSocket;
begin
  LIOHandler := TIdIOHandlerSocket.Create(nil);
  LIOHandler.Open;
  if LIOHandler.Binding.Accept(ASocket) then begin
    result := LIOHandler;
  end
  else begin
    Result := nil;
    FreeAndNil(LIOHandler);
  end;
end;

end.
 