/*
 * Decompiled with CFR 0.152.
 */
package com.superhac.JXBStreamer.Core;

import com.superhac.JXBStreamer.Core.Debug;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;

public class XBMSPxmlEncoder {
    private static Logger logger = Debug.getLogger();

    protected static String encodeEntry(File entry) {
        String data = null;
        if (entry.isDirectory()) {
            if (Debug.debug) {
                logger.info("Encoding directory entry in XML..");
            }
            data = "<DIRECTORYITEM>";
            data = String.valueOf(data) + "<NAME>" + entry.getName() + "</NAME>";
            data = String.valueOf(data) + "<INFO></INFO>";
            data = String.valueOf(data) + "<ATTRIB>directory</ATTRIB>";
            data = String.valueOf(data) + "</DIRECTORYITEM>";
        } else {
            if (Debug.debug) {
                logger.info("Encoding a file entry in XML..");
            }
            data = "<DIRECTORYITEM>";
            data = String.valueOf(data) + "<NAME>" + entry.getName() + "</NAME>";
            data = String.valueOf(data) + "<PATHNAME DEPTH=\"1\">";
            data = String.valueOf(data) + "<COMPONENT LEVEL =\"1\">" + entry.getName() + "</COMPONENT>";
            data = String.valueOf(data) + "</PATHNAME>";
            data = String.valueOf(data) + "<ATTRIB>file</ATTRIB>";
            data = String.valueOf(data) + "<SIZE>" + entry.length() + "</SIZE>";
            data = String.valueOf(data) + "<TIME>";
            data = String.valueOf(data) + "<ACCESS>" + entry.lastModified() + "</ACCESS>";
            data = String.valueOf(data) + "<MODIFICATION>" + entry.lastModified() + "</MODIFICATION>";
            data = String.valueOf(data) + "<CHANGE>" + entry.lastModified() + "</CHANGE>";
            data = String.valueOf(data) + "</TIME>";
            data = String.valueOf(data) + "<INFO></INFO>";
            data = String.valueOf(data) + "</DIRECTORYITEM>";
        }
        byte[] convert = data.getBytes();
        try {
            data = new String(convert, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("ERROR: " + e);
            System.exit(1);
        }
        return data;
    }
}

