/*
 * Decompiled with CFR 0.152.
 */
package com.superhac.JXBStreamer.Core;

import com.superhac.JXBStreamer.Core.InternalIPFinder;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class XBMSPDiscoverServer
extends Thread {
    private int port = 1400;
    private String serverIP;
    private DatagramSocket socket;
    private boolean running = false;
    private boolean stopThread = false;

    protected XBMSPDiscoverServer(int port) {
        this.port = port;
        this.serverIP = InternalIPFinder.getLocalIPAddress();
        XBMSPDiscoverServer thread = this;
        thread.start();
    }

    public void run() {
        while (!this.stopThread) {
            if (this.running) {
                this.initServer();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void startServer() {
        if (!this.running) {
            this.running = true;
        }
    }

    protected void stopServer() {
        this.running = false;
        this.socket.close();
    }

    protected void stopThread() {
        this.stopThread = true;
        this.running = false;
        this.socket.close();
    }

    private void initServer() {
        try {
            System.out.println("Server started...");
            DatagramPacket packet = new DatagramPacket(new byte[512], 512);
            this.socket = new DatagramSocket(null);
            this.socket.bind(new InetSocketAddress(this.port));
            while (this.running) {
                this.socket.receive(packet);
                this.process(packet);
            }
        }
        catch (SocketException e) {
            this.running = false;
        }
        catch (IOException e) {
            this.running = false;
        }
        this.running = false;
    }

    private void process(DatagramPacket packet) {
        ByteBuffer buffer = ByteBuffer.allocate(1500);
        buffer.put(packet.getData());
        buffer.flip();
        int size = buffer.getInt();
        byte type = buffer.get();
        int messageID = buffer.getInt();
        int clientVersionSize = buffer.getInt();
        byte[] string = new byte[clientVersionSize];
        int i = 0;
        while (i < clientVersionSize) {
            string[i] = buffer.get();
            ++i;
        }
        buffer.clear();
        int lengthOfServerVersion = "XBMSP-1.0 1.0 JXBStreamer Media Server 1.0\n".length();
        int lengthOfServerIP = this.serverIP.length();
        int lengthOfPort = String.valueOf(this.port).length();
        int serverComment = 0;
        int typeSize = 1;
        int messageSize = typeSize + 4 + lengthOfServerIP + lengthOfPort + lengthOfServerVersion + serverComment + 16;
        buffer.putInt(messageSize);
        buffer.put((byte)91);
        buffer.putInt(messageID);
        buffer.putInt(lengthOfServerIP);
        buffer.put(this.serverIP.getBytes());
        buffer.putInt(lengthOfPort);
        buffer.put(String.valueOf(this.port).getBytes());
        buffer.putInt(lengthOfServerVersion);
        buffer.put("XBMSP-1.0 1.0 JXBStreamer Media Server 1.0\n".getBytes());
        buffer.putInt(serverComment);
        buffer.flip();
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        try {
            this.socket.send(new DatagramPacket(data, data.length, packet.getAddress(), packet.getPort()));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setPort(int port) {
        this.port = port;
    }
}

