/****************************************************************
  XBox media server v0.30.1 (with less ugly code included for free)

  Ugly code by J-F Mammet <jeff@bidou.info>
  Not ugly code by BigUglyFool
  Network protocol by Runtime
  XBPlayer by Runtime & d7o3g4q
  Header cleanup by Stefan Mansby <stefan@nis.nu>

  This code works on other people computer, but not on mine
  If you encounter any problem, contact me !
***************************************************************/

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>   
#include <fcntl.h>
#include <stdlib.h>

#define SUCCESS 0
#define ERROR   1

/* #define SERVER_PORT 1400 */
#define MAX_MSG_LENGTH 1000
#define MAX_NAME_LENGTH 1000
#define MAX_CMD_LENGTH 4
#define MSG_LENGTH 32

/* This should be the only thing to configure for the moment */
#define MEDIA_FILES_PATH "/tmp/media"

int usage(char *prog)
{
  printf("Usage:");
  printf("%s [options]\n\n", prog);
  printf("\t-d [media dir]\n");
  printf("\t-p [port]\n");
  printf("\t-u [username to run as]\n");
  printf("\t-D [level] debug mode (lvl 2 VERY verbose)\n");
  printf("\t-h help\n");
  exit(1);
}

/* This function does not make any safety check, beware ! */
int substr(char *buf, char **dest, int s, int l,int e)
{
  //ret = (char*)malloc(l+1);
  if (e == 1)
    memset(*dest,0x0,l+1);
  memcpy(*dest,buf+s,l);
  return 1;
}

/* Returns the string aligned to the left */
int pad_right(char *str,char **dest, char chr, int length)
{
  char *tempstr;
  //*dest = (char *)malloc(length+1);
  tempstr = (char *)malloc(length+1);
  memset(tempstr,chr,length - strlen(str));
  tempstr[length - strlen(str)] = '\0';
  sprintf(*dest,"%s%s",str,tempstr);
  free(tempstr);
  return 1;
}

int check_command(char *line,FILE **file,char **CMD, char **PAYLOAD, int *payloadSize, char **CURRENT_PATH, char TARGET_PATH[512], int DEBUG)
{
  char *cmd;
  char *ptr;
  char *fileName;
  char *targetfileName;
  struct stat st;
  int size1,size2;
  DIR *dirp;
  struct dirent *direntp;
  char *ext;
  static char *tempbuf;
  int cnt;
  int ret=0;
  char TEMP_PATH[512];

  *CMD = (char *)malloc(MAX_MSG_LENGTH);
  memset(*CMD,0x0,MAX_MSG_LENGTH);
  cmd = malloc(10);

  if (!substr(line,&cmd,0,4,1))
    {
      printf("substr error\n");
      free(cmd);
      return ERROR;
    }	
  
  if (DEBUG >= 2)
    printf("LINE:%s\nCMD: %s\n", line, cmd);
  
  /***************** XBOX IS CONNECTING *****************/
  if (strcmp(line,"HELLO XSTREAM 6.0") == 0)
    {
      if (DEBUG >= 1)
	printf("Greetings, xbox !\n");
      strcpy(*CMD,"HELLO XBOX!");
      ret = 1;
    }

  /****************** OPEN A FILE ***********************/
  if (strcmp(cmd,"OPEN") == 0)
    {
      /* open the file */
      if (DEBUG >= 1)
	printf("OPEN\n");
      
      /* Get the argument after comma */
      ptr = strtok(line,",");
      ptr = strtok(NULL,",");
      
      fileName = (char *)malloc(MAX_NAME_LENGTH);
      targetfileName = (char *)malloc(MAX_NAME_LENGTH);
      
      /* Check if the file is already opened, since the XBPlayer code does not send the CLSE command yet */
      if (*file != NULL)
	fclose(*file);
      
      /* Let's strip the $ character to get the true file name */
      substr(ptr,&fileName,1,strlen(ptr)-1,1);

      /* Create a new filename containing the default media path */
      sprintf(targetfileName, "%s%s",TARGET_PATH,*CURRENT_PATH);

      /* Attach the requested filename to the end. */
      strcat(targetfileName, fileName);

      /* If /../ exists in our filename, we will report it and refuse */
      /* to open the requested file.  Otherwise processing should continue */
      if (!strstr(fileName,"/../")) 
	{
	  if (!(*file = fopen(targetfileName,"r")))
	    {
	      if (DEBUG >= 1)
		{
		  printf("%s\n",targetfileName);
		  perror("Cannot open file ");
		}
	      strcpy(*CMD,"-1 UNABLE TO OPEN");
	      free(fileName);
	      free(targetfileName);
	      ret = 1;
	    }
	  else
	    {
	      fstat(fileno(*file),&st);
	      sprintf(*CMD,"%d OK",(int)st.st_size);
	      free(fileName);
	      free(targetfileName);
	      ret = 1;
	    }
	}
      else
	printf("Illegal string in filename: %s\n", fileName); 
    }

  /***************************** READ A PART OF A FILE ****************/
  if (strcmp(cmd,"READ") == 0)
    {
      /* read part of the file */
      if (!(strchr(line,',')))
	printf("No comma in command line, ignoring\n");
      else
	{
	  /* let's get the second token, it's the length of the packet wanted */
	  ptr = strtok(line,",");
	  ptr = strtok(NULL,",");
	  size1 = atoi(ptr);
	  ptr = strtok(NULL,",");
	  size2 = atoi(ptr);
	  
	  if (size2 > 0)
	    {
	      if ((file == NULL))
		{
		  printf("File not opened !\n");
		  /* Send a 0 OK message so XBPlayer knows it's the "end" of the stream... */
		  strcpy(*CMD,"0 OK");
		  ret = 1;
		}
	      else
		{
		  *PAYLOAD = (char *)calloc(size2,1);
		  fseek(*file,size1,SEEK_SET);
		  if ((*payloadSize = fread((*PAYLOAD),1,size2,*file)))
		    {
		      sprintf(*CMD,"%d OK",*payloadSize);
		      /* let's pad the result to the right of a 32 bytes string */
		      ret = 2;
		    }
		  else
		    {
		      if (feof(*file))
			{
			  /* We have reached the end of the file, send a 0 length header so the xbox knows
			     about it ! */
			  if (DEBUG >= 1)
			    printf("Past file end !\n");
			  strcpy(*CMD,"-1 READ FAILED");
			  ret = 1;
			}
		      else
			printf("can't read from file !\n");
		    }
		  
		  /* Do some cleanup ! */
		}
	    } /* buffer size is ok */
	  else
	    printf("0 or invalid paramater for READ, ignoring\n");
	} /* comma detected */
    }

  /******************************* TELL ************************/
  if (strcmp(cmd,"TELL") == 0)
    {
      /* sends the current position in the file stream */
      size1 = ftell(*file);
      if (size1 >= 0)
	{
	  sprintf(*CMD,"%d OK",size1);
	  ret = 1;
	}
      else
	{
	  strcpy(*CMD,"-1 TELL FAILED");
	  ret = 1;
	}
    }

  /***************************** CLOSE ************************/
  if (strcmp(cmd,"CLSE") == 0)
    {
      /* close the file */
      if (*file != NULL)
	{
	  fclose(*file);
	  printf("Closing file\n");
	}
      else
	printf("File not opened ?\n");
      *file = NULL;
      
      /* send the answer */
      strcpy(*CMD,"0 OK");
      ret = 1;
    }
  
  /***************************** DBUG ************************/
  if (strcmp(cmd,"DBUG") == 0)
    {
      strcpy(*CMD,"0 OK");
      ret = 1;
    }
  
  /***************************** INFO ************************/
  if (strcmp(cmd,"INFO") == 0)
    {
      /* Not implemented yet ! */
      strcpy(*CMD,"-1 NO INFO");
      ret = 1;
    }

  /***************************** *CAT ************************/
  if (strcmp(cmd,"*CAT") == 0)
    {
      fileName = (char *)malloc(MAX_NAME_LENGTH);
      targetfileName = (char *)malloc(MAX_NAME_LENGTH);

      /* Get the character after the comma, if any */
      ptr = strtok(line,",");
      if ((ptr = strtok(NULL,",")))
	{
	  /* Check the command */
	  if (!strcmp(ptr,"BACK"))
	    {
	      /* We can't go back if the current path is empty ! */
	      if (strlen(*CURRENT_PATH) > 0)
		{
		  tempbuf = (char *)malloc(MAX_NAME_LENGTH);
		  strcpy(tempbuf,rindex(*CURRENT_PATH,'/'));
		  substr(*CURRENT_PATH,&fileName,0,strlen(*CURRENT_PATH)-strlen(tempbuf),1);
		  strcpy(*CURRENT_PATH,fileName);
		  free(tempbuf);
		}
	    }
	  else
	    {
	      substr(ptr,&fileName,1,strlen(ptr)-1,1);
	      strcat(*CURRENT_PATH,fileName);
	    }
	}

      tempbuf = (char *)malloc(MAX_NAME_LENGTH);
      sprintf(TEMP_PATH,"%s%s",TARGET_PATH,*CURRENT_PATH);

      if (DEBUG >= 1)
	printf("Directory: %s\n",TEMP_PATH);

      *PAYLOAD = (char *)malloc(strlen("<SHARES>\n")+1);
      sprintf(*PAYLOAD,"<SHARES>\n");

      dirp = opendir(TEMP_PATH);
      cnt = 0;
      while ((direntp = readdir(dirp)) != NULL)
	{
	  strcpy(fileName,direntp->d_name);
	  sprintf(targetfileName,"%s/%s",TEMP_PATH,fileName);
	  stat(targetfileName,&st);
	  if (S_ISDIR(st.st_mode))
	    {
	      if (strcmp(fileName,".") && strcmp(fileName,".."))
		{
		  sprintf(tempbuf,"<ITEM><ATTRIB>16</ATTRIB><PATH>%c/%s</PATH></ITEM>\n",'$',fileName);
		  *PAYLOAD = (char *)realloc(*PAYLOAD,strlen(tempbuf)+strlen(*PAYLOAD)+2);
		  strcat(*PAYLOAD,tempbuf);
		  cnt++;
		}
	    }
	  if (S_ISREG(st.st_mode))
	    {
	      if (DEBUG >= 2)
		printf("%s\n",targetfileName);
	      /* let's get the extension */
	      ext = strtok(direntp->d_name,".");
	      while ((ptr = strtok(NULL,".")))
		strcpy(ext,ptr);
	      if (ext != NULL)
		{
		  /* Remove the PATH and just give the server the items */
		  sprintf(tempbuf,"<ITEM><ATTRIB>128</ATTRIB><PATH>%c/%s</PATH></ITEM>\n",'$',fileName);
		  *PAYLOAD = (char *)realloc(*PAYLOAD,strlen(tempbuf)+strlen(*PAYLOAD)+2);
		  strcat(*PAYLOAD,tempbuf);
		  cnt++;
		}
	    }
	}
      closedir(dirp);

      free(tempbuf);
      free(fileName);
      free(targetfileName);
      if (cnt > 0)
	{
	  /* We found at least one media file, we can finish the buffer*/
	  *PAYLOAD = (char *)realloc(*PAYLOAD,strlen(*PAYLOAD)+strlen("</SHARES>")+1);
	  strcat(*PAYLOAD,"</SHARES>");
	  sprintf(*CMD,"%d OK",strlen(*PAYLOAD));
	  *payloadSize = strlen(*PAYLOAD);
	  ret = 2;
	}
      else
	{ /* No file found ! */
	  strcpy(*CMD,"-1 READ FAILED");
	  strcpy(*CURRENT_PATH,"");
	  ret = 1;
	}
    }

  free(cmd);
  return ret;
}

int main (int argc, char *argv[])
{
  int sd, newSd, cliLen;
  int ret;
  int flag;
  int opt;
  int DEBUG=0;
  int SERVER_PORT=1400;
  char *line;
  char *msg;
  char *cmd;
  char *linetmp;
  char *CMD;
  char *PAYLOAD;
  char *CURRENT_PATH;
  int payloadSize;
  char user[16];  /* yeah too big...sue me */
  char TARGET_PATH[512];

  struct sockaddr_in cliAddr, servAddr;
  FILE *file = NULL;

  /* Need to set this up early. */
  strcpy(TARGET_PATH, MEDIA_FILES_PATH);

  while ((opt = getopt(argc, argv, "d:u:p:D:h")) != EOF)
      switch(opt) {
        case 'd': 
            strcpy(TARGET_PATH,optarg);
            break;
        case 'u': 
            strcpy(user,optarg);
            break;
        case 'p': 
            SERVER_PORT=atoi(optarg);
            break;
        case 'D': 
            DEBUG=atoi(optarg);
            break;
        case 'h': 
            usage(argv[0]);
            break;
        case '?': 
            printf("Unknown option: %s\n", optarg); 
            usage(argv[0]); 
            break;
        default: 
            usage(argv[0]);
            break;
      }

  cmd = (char*)malloc(MAX_CMD_LENGTH);
  linetmp = (char*)malloc(MAX_MSG_LENGTH);
  line = (char*)malloc(MAX_MSG_LENGTH);
  msg = (char*)malloc(MAX_MSG_LENGTH);
  CURRENT_PATH = (char*)malloc(MAX_MSG_LENGTH);

  strcpy(CURRENT_PATH,"");

  printf("Port: %u\n", SERVER_PORT);
  printf("Directory: %s\n", TARGET_PATH);

  /* create socket */
  sd = socket(AF_INET, SOCK_STREAM, 0);

  if (sd < 0)
    {
      perror("cannot open socket ");
      return ERROR;
    }
  
  /* Does not seem to work on linux 2.4.18+ */
  flag = 1;
  setsockopt (sd, SOL_SOCKET, SO_REUSEADDR, (char *) &flag, sizeof(int));
  setsockopt (sd, IPPROTO_TCP, TCP_NODELAY, (char *) &flag, sizeof(int));

  /* bind server port */
  servAddr.sin_family = AF_INET;
  servAddr.sin_addr.s_addr = htonl(INADDR_ANY);
  servAddr.sin_port = htons(SERVER_PORT);
  if (bind(sd, (struct sockaddr *) &servAddr, sizeof(servAddr)) < 0)
    {
      perror("cannot bind port ");
      return ERROR;
    }

  listen(sd,5);
  
  while (1)
    {
      if (DEBUG >= 1)
      printf("%s: waiting for commands on port TCP %u\n",argv[0],SERVER_PORT);

      cliLen = sizeof(cliAddr);
      /* Create the client socket */
      newSd = accept(sd, (struct sockaddr *) &cliAddr, &cliLen);

      flag = 1;
      setsockopt (newSd, IPPROTO_TCP, TCP_NODELAY, (char *) &flag, sizeof(int));
      flag = 2048;
      setsockopt (newSd, IPPROTO_TCP, TCP_MAXSEG, (char *) &flag, sizeof(int));

      if (newSd<0)
	{
	  perror("cannot accept connection ");
	  return ERROR;
	}

      /* init line */
      memset(line,0x0,MAX_MSG_LENGTH);
    
      /* receive commands */
      while(read(newSd,line,MAX_MSG_LENGTH) > 0)
	{
	  /* strip all unwanted characters */
	  if ((strchr(line,10)))
	    {
	      substr(line,&linetmp,0,strlen(line)-1,1);
	      strcpy(line,linetmp);
	    }
	  if ((strchr(line,13)))
	    {
	      substr(line,&linetmp,0,strlen(line)-1,1);
	      strcpy(line,linetmp);
	    }

	  /* Check what do do with the line */
	  ret = check_command(line,&file,&CMD,&PAYLOAD,&payloadSize,&CURRENT_PATH, TARGET_PATH, DEBUG);

	  /* There is a CMD */
	  if (ret >= 1)
	    {
	      pad_right(CMD,&linetmp,' ',strlen(CMD));
	      strcpy(msg,linetmp);
	      write(newSd,msg,strlen(msg));
	      free(CMD);
	    }
	  /* There is a payload too */
	  if (ret == 2)
	    {
	      write(newSd,PAYLOAD,payloadSize);
	      free(PAYLOAD);
	    }

	  memset(line,0x0,MAX_MSG_LENGTH);
	} /* while(read) */

      close(newSd);
      file = NULL;
      if (DEBUG >= 1)
	printf("Connection closed\n");

    } /* while (1) */
  free(linetmp);
  free(line);
  free(msg);
  free(cmd);
}


