unit main;
// (c) 2002 by Remco Sonnema
// Part of RelaX
// released under GNU General Public License
// coded in Delphi 6 pro (www.borland.com)
interface

uses
  windows            // Delphi VCL
  {$WARN UNIT_PLATFORM OFF} //damn!.. not available on kylix/linux :(
 ,FileCtrl           // Delphi VCL
  {$WARN UNIT_PLATFORM ON}
 ,StdCtrls           // Delphi VCL
 ,Controls           // Delphi VCL
 ,ExtCtrls           // Delphi VCL
 ,ImgList            // Delphi VCL
 ,ComCtrls           // Delphi VCL
 ,Menus              // Delphi VCL
 ,Forms              // Delphi VCL
 ,Classes            // Delphi VCL
 ,Sysutils           // Delphi VCL
 ,Grids              // Delphi VCL
 ,ValEdit            // Delphi VCL
 ,Dialogs            // Delphi VCL
 ,IdAntiFreezeBase   // Part of Indy Delphi Components Suite
 ,IdAntiFreeze       // Part of Indy Delphi Components Suite
 ,IdBaseComponent    // Part of Indy Delphi Components Suite
 ,IdComponent        // Part of Indy Delphi Components Suite
 ,IdTCPServer        // Part of Indy Delphi Components Suite
 ,JanXMLParser2      // Part of EasyXML 2.1
 ,ToolWin            // Delphi VCL
 ,Spin               // Delphi VCL
 ,ActnList           // Delphi VCL
 ,IdTCPConnection    // Part of Indy Delphi Components Suite
 ,IdTCPClient        // Part of Indy Delphi Components Suite
 ,IdHTTP             // Part of Indy Delphi Components Suite
 ;

Const
  Version = '0.2';
type
  TForm1 = class(TForm)
    IdTCPServer1: TIdTCPServer;
    IdAntiFreeze1: TIdAntiFreeze;
    PageControl1: TPageControl;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    Memo1: TMemo;
    StatusBar1: TStatusBar;
    TabSheet6: TTabSheet;
    ScrollBox1: TScrollBox;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    FileListBox1: TFileListBox;
    ImageList1: TImageList;
    Panel2: TPanel;
    Panel1: TPanel;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    TabSheet1: TTabSheet;
    ValueListEditor1: TValueListEditor;
    Panel3: TPanel;
    Panel4: TPanel;
    TreeView1: TTreeView;
    PopupMenu1: TPopupMenu;
    Insert1: TMenuItem;
    Add1: TMenuItem;
    ActionList1: TActionList;
    Label1: TLabel;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    Label2: TLabel;
    actDelete: TAction;
    actAdd: TAction;
    cbxFlattenforb5: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    IdHTTP1: TIdHTTP;
    actMoveUp: TAction;
    actMoveDown: TAction;
    Movedown1: TMenuItem;
    Moveup1: TMenuItem;
    Timer1: TTimer;
    N1: TMenuItem;
    Checkforupdates1: TMenuItem;
    Label6: TLabel;
    lblAttribute: TLabel;
    lblPath: TLabel;
    lblRecursive: TLabel;
    actRename: TAction;
    Rename1: TMenuItem;
    actSaveConfig: TAction;
    N2: TMenuItem;
    SaveConfig1: TMenuItem;
    procedure IdTCPServer1Connect(AThread: TIdPeerThread);
    procedure IdTCPServer1Disconnect(AThread: TIdPeerThread);
    procedure FormCreate(Sender: TObject);
    procedure TreeView1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure TreeView1DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure DirectoryListBox1StartDrag(Sender: TObject;
      var DragObject: TDragObject);
    procedure FileListBox1StartDrag(Sender: TObject;
      var DragObject: TDragObject);
    procedure FormDestroy(Sender: TObject);
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure TreeView1Editing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure TreeView1Collapsing(Sender: TObject; Node: TTreeNode;
      var AllowCollapse: Boolean);
    procedure TreeView1Edited(Sender: TObject; Node: TTreeNode;
      var S: String);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure actDeleteExecute(Sender: TObject);
    procedure actAddExecute(Sender: TObject);
    procedure actDeleteUpdate(Sender: TObject);
    procedure actInsertUpdate(Sender: TObject);
    procedure actAddUpdate(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure actMoveUpExecute(Sender: TObject);
    procedure actMoveDownExecute(Sender: TObject);
    procedure actMoveUpUpdate(Sender: TObject);
    procedure actMoveDownUpdate(Sender: TObject);
    procedure Checkforupdates(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure actRenameUpdate(Sender: TObject);
    procedure actRenameExecute(Sender: TObject);
    procedure actSaveConfigExecute(Sender: TObject);
  private
    config : TjanXMLParser2;
    shares : TJanXMLNode2;
    Procedure Log(debuglevel:Integer;S:STring;AThread: TIdPeerThread);
    procedure NodesToTree(aNode: TJanXMLNode2; aTreeNode: TTreeNode);
    procedure ProcessITEM(ITEM: TJanXMLNode2; aTreeNode: TTreeNode);
    procedure Exceptionhandler(Sender: TObject; E: Exception);
  end;

var
  Form1: TForm1;

implementation

uses
   downloadframe     // Part of RelaX - download information panel
  ,IdSocketHandle    // Part of Indy Delphi Components Suite
  ,IdIOHandlerSocket // Part of Indy Delphi Components Suite
  ,IdStackConsts     // Part of Indy Delphi Components Suite
  ,AviInfo           // old unit by me
  ,About             // old unit by me
  ,ump3object        // old unit by me
  ,updated
  ;

{$R *.dfm}
// function to maximize a string to a certain length
Function MAX(s:String;L:integer):String;
Begin
  Result := s;
  while length(result)<l do result := result + ' ';
End;

// strip the next parameter from a string till a ',' comes along
function GetNextParam(var param:String):String;
var
  tmp : String;
Begin
  tmp := '';
  While (length(param)>0) and (param[1]<>',') do
    Begin
      tmp := tmp + param[1];
      delete(param,1,1);
    End;
  delete(param,1,1);
  Result := tmp;
End;

function GetItemListFromXMLNode(XMLNode:TjanXMLNode2;Version:String):String;forward;

Type // object to synchronise display events with main thread
  TDisplayObject=Class(Tobject)
  Public
    dlstatus : Tdlstatus;
    Parent : TWinControl;
    Filename : String;
    Progress : Integer;
    MaxValue : Integer;
    MinValue : Integer;
    RemoteIP : String;
    Procedure Start;
    Procedure Update;
    Procedure Stop;
  End;

  { TDisplayObject }
  procedure TDisplayObject.Stop;
  begin
    FreeAndNil(dlstatus);
  end;

  procedure TDisplayObject.Start;
  begin
    dlstatus := tdlstatus.Create(Nil);
    dlstatus.Align:= alTop;
    dlstatus.Parent := Parent;
    dlstatus.lblFilename.Caption := Filename;
    dlstatus.PbarPosition.MaxValue := MaxValue;
    dlstatus.PbarPosition.Progress := Progress;
    dlstatus.PbarPosition.MinValue := MinValue;
    dlstatus.lblRemoteIP.Caption := RemoteIP;
  end;

  procedure TDisplayObject.Update;
  begin
    dlstatus.lblFilename.Caption := Filename;
    dlstatus.PbarPosition.MaxValue := MaxValue;
    dlstatus.PbarPosition.Progress := Progress;
    dlstatus.PbarPosition.MinValue := MinValue;
    dlstatus.lblRemoteIP.Caption := RemoteIP;
  end;

// this function is called by indy tcpserver
// this is the handler from the xbox mediaplayer requests
procedure TForm1.IdTCPServer1Connect(AThread: TIdPeerThread);
var
  Greeting : String;
  command : String;
  tmp:String;
  param : String;
  x:Longint;
  done : Boolean;
  MediaStream : TFileStream;
  Response : String;
  ResponseData : String;
  lastpos : Longint;
  buf:array[1..400000] of byte;
  bufzise : Longint;
  tmpAviInfo:Avi_info;
  DisplayObject : TDisplayObject;

  Title: String;
  Artists : String;
  Summary : String;
  Picture : String;

  Mp3Info:TMp3Object;

begin
  // need nodelay for FAST streaming! Thanks runtime!
  (aThread.Connection.IOHandler as TIdIOHandlerSocket).Binding.SetSockOpt(Id_IPPROTO_TCP, Id_TCP_NODELAY, PChar(@Id_SO_True), SizeOf(Id_SO_True));

  Log(0,'---------------------------------------------------------------------------',aThread);
  log(2,'Incomming connection from '+(AThread.Connection.IOHandler as TIdIOHandlerSocket).Binding.PeerIP,aThread);
  Log(1,'Waiting for greeting',aThread);
  Greeting := aThread.Connection.ReadLn(#10,4000,2000);
  Log(1,'received greeting :'+greeting,aThread);
  Log(1,'Sending greeting : HELLO XBOX!',aThread);
  aThread.connection.Write('HELLO XBOX!');

  AThread.Connection.ReadTimeout:=1000;
  Log(1,'Waiting in endles loop for commands',aThread);
  done := false;
  aThread.Priority := tpHighest;
  Lastpos := 0;
  DisplayObject := Nil;
  While not done do
    Try
      done := False;
      Response := '-1 UNKNOWN ERROR';
      ResponseData := '';
      bufzise := 0;

      command := aThread.Connection.ReadString(4);
      if command='' then
        memo1.lines.Text := memo1.lines.text+'no command'
      else
        Begin
          if command<>'READ' then
            Log(1,'Command gotten : '+command,aThread);
          if command = '*CAT' then
            Begin
              param := aThread.Connection.ReadString(aThread.Connection.Inputbuffer.Size);

              tmp := '<catalogue>'+#13#10;
              tmp := tmp+GetItemListFromXMLNode(shares,'B5');
              tmp := tmp + '</catalogue>'+#13#10;
              Response := inttostr(length(tmp))+' OK';
              ResponseData := tmp;

              Done := True;
            End;
          if command = 'OPEN' then
            Begin
              Log(1,'reading OPEN param',aThread);
              aThread.Connection.Readchar;
              param := aThread.Connection.ReadString(aThread.Connection.Inputbuffer.Size);
              Log(1,' param '+param,AThread);
              if fileExists(param) then
                Begin
                  MediaStream := TFileStream.Create(param,fmOpenRead);
                  Response := Inttostr(MediaStream.Size)+' OK';
                  DisplayObject := TDisplayObject.Create;
                  DisplayObject.Parent := Scrollbox1;
                  DisplayObject.Filename := extractfilename(param);
                  DisplayObject.Progress := 0;
                  DisplayObject.MaxValue := MediaStream.Size;
                  DisplayObject.MinValue := 0;
                  DisplayObject.RemoteIP := (AThread.Connection.IOHandler as TIdIOHandlerSocket).Binding.PeerIP;
                  AThread.Synchronize(DisplayObject.Start);


                  Log(1,' File Found ',aThread);
                  Lastpos := 0;
                  Done := False;
                end
              else
                Begin
                  Response := '-1 UNABLE TO OPEN';
                  Log(1,' File not found',aThread);
                  Done:=True;
                End;
            End;

          if command = 'INFO' then
            Begin
              Log(1,'reading INFO param',aThread);
              aThread.Connection.Readchar;
              param := aThread.Connection.ReadString(aThread.Connection.Inputbuffer.Size);
              Log(1,' param '+param,aThread);
              tmp := '<media><share>notimportant</share>';
              Picture := '';
              Title := '';
              Artists := '';
              Summary := '';
              if Uppercase(ExtractFileExt(param))='.AVI' then
                Begin
                  tmpAviInfo := GetAviInfo(param);
                  Title   := 'Compressor  '+tmpAviInfo.Compressor;
                  Artists := 'Aspect    '+tmpAviInfo.Aspect;
                  summary := 'Duration  '+tmpAviInfo.Duration;
                End;
              if Uppercase(ExtractFileExt(param))='.MP3' then
                Begin
                  Mp3Info:=TMp3Object.Create(Nil);
                  Mp3Info.Mp3File := param;
                  Title   := 'Bitrate   '+Mp3Info.MpegType+'  '+Mp3Info.Layer+'  '+Mp3Info.BitRate+'kbps  '+Mp3Info.ChannelMode;
                  Artists := 'Size        '+Mp3Info.Size;
                  Summary := 'Duration  '+Mp3Info.Time;
                  FreeAndNil(Mp3Info);
                End;
              tmp := tmp+'<title>'+Title+'</title>';
              tmp := tmp+'<artists>'+Artists+'</artists>';
              tmp := tmp+'<summary>'+summary+'</summary>';
              tmp:=tmp+'</media>';
              Response := inttostr(length(tmp))+' OK';
              ResponseData := tmp;
              Done := True;
            end;

          if command = 'READ' then
            Begin
              aThread.Connection.Readchar;
              param := aThread.Connection.ReadString(aThread.Connection.Inputbuffer.Size);
              Done := False;
              if assigned(MediaStream) then
                Begin
                  tmp := GetNextParam(param);
                  x:=StrToInt(Tmp);
                  if lastpos <> x then
                    MediaStream.Position := x;
                  tmp := GetNextParam(param);
                  x:= StrToInt(tmp);
                  bufzise := MediaStream.Read(buf,x);
                  lastpos := lastpos + bufzise;
                  if assigned(displayobject) then
                    Begin
                      DisplayObject.Progress := lastpos;
                      AThread.Synchronize(DisplayObject.Update);
                    End;
                  Response := inttostr(bufzise)+' OK';
                  ResponseDAta := '';
                End
              Else
                Begin
                  Response := '-1 READ FAILED';
                  Done := True;
                End;
            end;
          if command = 'TELL' then
            Begin
              if assigned(MediaStream) then
                Response := Inttostr(MediaStream.Position)+' OK'
              Else
                Response := '-1 TELL FAILED';
            end;

          if command = 'CLSE' then
            Begin
              FreeAndNil(MediaStream);
              Response := '0 OK';
              Done := True;
            end;

          if command = 'DBUG' then
            Begin
              Response := '0 OK';
            end;

          Response := MAX(Response,32);
          aThread.Connection.WriteBuffer(Response[1],Length(Response),true);
          if ResponseData <> '' then
            aThread.Connection.WriteBuffer(Responsedata[1],Length(Responsedata),true);
          if bufzise <> 0 then
            aThread.Connection.WriteBuffer(buf,bufzise,true);
          if done then
            aThread.Connection.Disconnect;
          application.ProcessMessages;
        End;
    except
      on e:exception do
        Begin
          log(5,e.Message,aThread);
          Done := True;
          aThread.Connection.Disconnect;
        End;
    End;
  Log(0,'End of it all',aThread);
  if assigned(DisplayObject) then
    Try
      AThread.Synchronize( DisplayObject.Stop );
      DisplayObject.Free;
    except
      on e:Exception do
        log(5,e.Message,aThread);
    End;
end;



procedure TForm1.IdTCPServer1Disconnect(AThread: TIdPeerThread);
begin
  Log(0,'Disconnected',athread);
end;

Function GetNodeByName(aName:String;aNodeList:TJanXMLNodeList2):TjanXMLNode2;
var
  x:Longint;
Begin
  Result := Nil;
  for x:=0 to aNodeList.Count-1 do
    Begin
      if Uppercase(aName) = Uppercase(TjanXMLNode2(aNodeList.Items[x]).name) then
        Begin
          Result := TjanXMLNode2(aNodeList.Items[x]);
          Exit;
        end;
    End;
End;

procedure TForm1.ProcessITEM(ITEM:TJanXMLNode2;aTreeNode:TTreeNode);
var
  attribute : TJanXMLNode2;
  Path : TJanXMLNode2;
  tmpTreeNode : TTreeNode;
Begin
  if uppercase(item.name)='ITEM' then
    begin
      attribute := GetNodeByName('ATTRIBUTE',item.nodes);
      Path := GetNodeByName('path',item.nodes);
      tmpTreeNode := nil;
      if assigned(path) and assigned(attribute) then
        tmpTreeNode := aTreeNode.Owner.AddChildObject(aTreeNode,path.text,item);
      if assigned(tmpTreeNode) then
        Begin
          case StrToInt(attribute.text) of
            0   : begin
                    tmpTreeNode.ImageIndex := 0;
                    NodesToTree(item,tmptreeNode);
                  End;
            16  : tmpTreeNode.ImageIndex := 2; // path
            128 : tmpTreeNode.ImageIndex := 1; // file
          End;
         tmpTreeNode.SelectedIndex := tmpTreeNode.ImageIndex;
        End;
    End;
End;

Procedure TForm1.NodesToTree(aNode:TJanXMLNode2;aTreeNode:TTreeNode);
var
  x: Longint;
Begin
  For x:=0 to aNode.nodes.Count-1 do
    ProcessITEM(TJanXMLNode2(aNode.nodes.Items[x]),aTreeNode);
End;

Function GetMediaFilesFromPath(Path:String;Recursive:Boolean):String;
var
  Diri:TSearchRec;
  res:Integer;
  Ext:String;
Begin
  Result := '';
  if (length(path)>0) and (path[length(path)]<>'\') then
    path:=path+'\';
  Res := Findfirst(path+'*.*',faanyfile,diri);
  While Res=0 do
    Begin
      if diri.Attr and faDirectory = faDirectory then
        Begin
          if (diri.Name <>'.') and (diri.name<>'..') and (Recursive=True) then
            Result := Result + GetMediaFilesFromPath(Path+diri.Name,Recursive)
        End
      Else
        Begin
          Ext := Uppercase(ExtractFileExt(Diri.name));
          if (length(ext)>0) and (Ext[1]='.') then
            Begin
              delete(ext,1,1);
            End;
          if   (Ext = 'AVI')
            or (Ext = 'MP2')
            or (Ext = 'MP3')
            or (Ext = 'MP4')
            or (Ext = 'MPG')
            or (Ext = 'WMA')
            or (Ext = 'WMV')
            or (Ext = 'DIVX')
          then
            Begin
              Result := Result + '<ITEM><ATTRIBUTE>128</ATTRIBUTE><PATH>'+path+diri.name+'</PATH></ITEM>'+#13#10;
            End;
        End;
      Res := Findnext(diri);
    End;
  FindClose(diri);
End;

function GetItemListFromXMLNode(XMLNode:TjanXMLNode2;Version:String):String;
var
  x: Longint;
  attribute : TJanXMLNode2;
  Path,item : TJanXMLNode2;
  Recursive : TJanXMLNode2;
  Recur:Boolean;
Begin
  Result := '';
  For x:=0 to XMLNode.nodes.Count-1 do
    Begin
      item :=TjanXMLNode2(XMLNode.nodes.Items[x]);
      if uppercase(item.name)='ITEM' then
        Begin
          attribute := GetNodeByName('ATTRIBUTE',item.nodes);
          Path := GetNodeByName('path',item.nodes);
          Recursive := GetNodeByName('Recursive',item.nodes);
          case StrToInt(attribute.text) of
            128 : Begin // file
                    Result := Result + '<ITEM><ATTRIBUTE>128</ATTRIBUTE><PATH>'+path.text+'</PATH></ITEM>'+#13#10;
                  end;
            16 : Begin // directory
                    Recur := True;
                    if assigned(Recursive) and (Recursive.text='0') then
                      Recur := False;
                    if Version = 'B5' then // Flatten for B5
                      Result := Result + GetMediaFilesFromPath(path.text,Recur)
                    Else                   // Show As Directory for B6
                      Result := Result + '<ITEM><ATTRIBUTE>16</ATTRIBUTE><PATH>'+path.text+'</PATH></ITEM>'+#13#10;

                 End;
            0 : Begin
                  Recur := True;
                  if assigned(Recursive) and (Recursive.text='0') then
                    Recur := False;
                  if Recur then // flatten for B5
                    Result := Result + GetItemListFromXMLNode(Item,Version)
                  Else         // show as directory for B6
                    Result := Result + '<ITEM><ATTRIBUTE>16</ATTRIBUTE><PATH>'+path.text+'</PATH></ITEM>'+#13#10;
                End;
          end;
        End;
    End;
End;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnException := Self.Exceptionhandler;
  if not FileExists(extractfilepath(paramstr(0))+'CONFIG.XML') then
    Begin
      ShowMessage('Error Config.XML does not exist!');
      Halt(0);
      Abort;
    End;
  Config := TjanXMLParser2.create;
  config.LoadXML(extractfilepath(paramstr(0))+'CONFIG.XML');
  Treeview1.Items.Clear;
  shares := GetNodeByName('SHARES',Config.nodes);

  if not assigned(shares) then
    Begin
      ShowMEssage('Error .. SHARES not found in XML');
      Halt(0);
      Abort;
    End;

  NodesToTree(shares,TreeView1.Items.AddObjectFirst(Nil,'SHARES',shares));
  TReeView1.Items[0].ImageIndex := 3;
  TReeView1.Items[0].SelectedIndex := 3;
  Treeview1.FullExpand;
  IdTCPServer1.Active := True;
end;

type TMyDragObject = class ( TDragObject )
       Filename : String;
       filetype : Integer;
     end;
procedure TForm1.TreeView1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  accept := assigned(TreeView1.GetNodeAt(x,y)) and (TreeView1.GetNodeAt(x,y).ImageIndex in[0,3]);
end;

function MakeXMLNode(aTagName:STring;aValue:String):TjanXMLNode2;
Begin
  Result := TJanXMLNode2.create;
  Result.name := aTagName;
  Result.text := aValue;
End;

procedure TForm1.TreeView1DragDrop(Sender, Source: TObject; X, Y: Integer);
var
  XMLNode : TjanXMLNode2;
begin
  if assigned(TreeView1.GetNodeAt(x,y)) then
    Begin
      XMLNode := MakeXMLNode('ITEM','');
      XMLNode.nodes.Add(MakeXMLNode('ATTRIBUTE',Inttostr((Source as TMyDragOBject).filetype)));
      XMLNode.nodes.Add(MakeXMLNode('PATH',(Source as TMyDragOBject).Filename));

      TjanXMLNode2(TreeView1.GetNodeAt(x,y).Data).addNode(XMLNode);
      ProcessITEM(XMLNode,TreeView1.GetNodeAt(x,y));
      TreeView1.GetNodeAt(x,y).Expand(True);
    End;
end;

procedure TForm1.DirectoryListBox1StartDrag(Sender: TObject;
  var DragObject: TDragObject);
begin
  dragobject := TMyDragObject.Create;
  DirectoryListBox1.OpenCurrent;
  (dragObject as TMyDragObject).Filename:=DirectoryListBox1.Directory;
  (dragObject as TMyDragObject).filetype:=16;
end;

procedure TForm1.FileListBox1StartDrag(Sender: TObject;
  var DragObject: TDragObject);
begin
  dragobject := TMyDragObject.Create;
  DirectoryListBox1.OpenCurrent;
  (dragObject as TMyDragObject).Filename:=FileListBox1.FileName;
  (dragObject as TMyDragObject).filetype:=128;
end;

Type // object to synchronise display events with main thread
  TLogUpdate = Class
  Public
    Line:String;
    Memo:TMemo;
    Procedure DoAddLog;
  End;
  Procedure TLogUpdate.DoAddLog;
  Begin
    Memo.Lines.Add(Line);
  End;

procedure TForm1.Log(debuglevel:Integer;S: STring;AThread: TIdPeerThread);
var
  Logger:TLogUpdate;
begin
  Logger := TLogUpdate.Create;
  Logger.Line := s;
  Logger.Memo := Memo1;
  if assigned(aThread) then
    aThread.Synchronize(Logger.DoAddLog)
  Else
    Logger.DoAddLog;
  FreeAndNil(Logger);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  config.SaveXML(extractfilepath(paramstr(0))+'CONFIG.XML');
  FreeAndNil(Config);
end;

procedure TForm1.TreeView1Change(Sender: TObject; Node: TTreeNode);
var
  tmpXML, attribute, path, recursive : TjanXMLNode2;
begin
  tmpXML := TjanXMLNode2(Node.Data);
  attribute := GetNodeByName('ATTRIBUTE',tmpxml.nodes);
  path := GetNodeByName('PATH',tmpxml.nodes);
  recursive := GetNodeByName('RECURSIVE',tmpxml.nodes);
  if assigned(attribute) then
    begin
      lblAttribute.caption := attribute.text;
      if attribute.text = '0' then
        lblAttribute.caption := attribute.text + ' Virtual directory';
      if attribute.text = '16' then
        lblAttribute.caption := attribute.text + ' Real Directory';
      if attribute.text = '128' then
        lblAttribute.caption := attribute.text + ' File';
    end
  else
    lblAttribute.caption := '';
      
  if assigned(path) then
    lblPath.caption := path.text
  else
    lblPath.caption := '';

  if assigned(recursive) then
    lblRecursive.caption := recursive.text
  else
    lblRecursive.caption := '';
end;

procedure TForm1.TreeView1Editing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
  AllowEdit := Node.ImageIndex=0;
end;

procedure TForm1.TreeView1Collapsing(Sender: TObject; Node: TTreeNode;
  var AllowCollapse: Boolean);
begin
  AllowCollapse := False;
end;

procedure TForm1.TreeView1Edited(Sender: TObject; Node: TTreeNode;
  var S: String);
begin
  if s='' then abort;
  GetNodeByName('PATH',TJanXMLNode2(Node.Data).nodes).text := s;
end;

procedure TForm1.PopupMenu1Popup(Sender: TObject);
begin
  if not assigned(TreeView1.Selected) then
    Abort;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  halt(0);
end;

procedure TForm1.actDeleteExecute(Sender: TObject);
begin
  TjanXMLNode2(TreeView1.Selected.Parent.data).deleteNode(TjanXMLNode2(TreeView1.Selected.data));
  TreeView1.Selected.Delete;
end;

procedure TForm1.actAddExecute(Sender: TObject);
var
  XMLNode : TjanXMLNode2;
begin
  XMLNode := MakeXMLNode('ITEM','');
  XMLNode.nodes.Add(MakeXMLNode('ATTRIBUTE','0'));
  XMLNode.nodes.Add(MakeXMLNode('PATH','Rename Please'));

  TjanXMLNode2(TreeView1.Selected.Data).addNode(XMLNode);
  ProcessITEM(XMLNode,TreeView1.Selected);
  TreeView1.Selected.Expand(True);
end;

procedure TForm1.actDeleteUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled :=
    (TreeView1.Selected.ImageIndex<>3);
end;

procedure TForm1.actInsertUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled :=
    (TreeView1.Selected.ImageIndex<>3);
end;

procedure TForm1.actAddUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled :=
    (TreeView1.Selected.ImageIndex in [3,0]);
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  About.TfrmAbout.Create(self).Show;
end;

procedure TForm1.Exceptionhandler(Sender: TObject; E: Exception);
begin
  Log(5,e.Message,Nil);
end;



procedure TForm1.actMoveUpExecute(Sender: TObject);
var
  tmp:TTreenode;
  tmpXML : TjanXMLNode2;
  parentXML : TjanXMLNode2;
begin
  // moving in treeview
  tmp := TreeView1.Selected;
  tmp.MoveTo(tmp.Parent.Item[tmp.index-1],naInsert);
  tmp.Expand(True);

  // moving in xml
  tmpXML := TjanXMLNode2(tmp.data);
  parentXML := tmpXML.parentNode;
  ParentXML.nodes.Move(ParentXML.nodes.IndexOf(tmpXML),ParentXML.nodes.IndexOf(tmpXML)-1);
end;

procedure TForm1.actMoveDownExecute(Sender: TObject);
var
  tmp:TTreenode;
  tmpXML : TjanXMLNode2;
  parentXML : TjanXMLNode2;
begin
  // moving in treeview
  tmp := TreeView1.Selected;
  if tmp.index=tmp.parent.count-2 then
    tmp.MoveTo(tmp.Parent.Item[tmp.index+1],naAdd)
  else
    tmp.MoveTo(tmp.Parent.Item[tmp.index+2],naInsert);
  tmp.Expand(True);
  // moving in xml
  tmpXML := TjanXMLNode2(tmp.data);
  parentXML := tmpXML.parentNode;
  ParentXML.nodes.Move(ParentXML.nodes.IndexOf(tmpXML),ParentXML.nodes.IndexOf(tmpXML)+1);
end;

procedure TForm1.actMoveUpUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled :=
    (TreeView1.Selected.ImageIndex <> 3) and (TreeView1.Selected.index>0);

end;

procedure TForm1.actMoveDownUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled :=
    (TreeView1.Selected.ImageIndex <> 3) and assigned(treeview1.selected.parent) and (treeview1.selected.index < (treeview1.selected.Parent.Count-1));
end;

procedure TForm1.Checkforupdates(Sender: TObject);
var
  s:String;
  sl:TStringlist;
  Upd:TfrmUpdated;
begin
  statusbar1.SimpleText := 'Checking for updates';
  Application.ProcessMessages;

  s:='';
  Try
    s := IdHTTP1.Get('http://updates.raforce.nl:8080/RelaX.Ver');
  Except
    on e:Exception do
      Begin
        statusbar1.SimpleText := 'Checking for updates Failed -'+e.Message;
        Exit;
      End;
  End;
  IdHTTP1.Disconnect;
  sl := TStringlist.Create;
  sl.text := s;
  if (sl.Count>1) and (Version <> sl.Strings[0]) then
    Begin
      statusbar1.SimpleText := 'Update found on server to V'+sl.strings[0];
      Upd:=TfrmUpdated.Create(Nil);
      upd.lblversion.Caption := sl.strings[0];
      upd.downloadurl.Caption := sl.Strings[1];
      sl.Delete(0);
      sl.Delete(0);
      upd.memoinfo.Text := sl.Text;
      upd.Show;
    End
  Else
    statusbar1.SimpleText := 'No update found - checked on ('+DateTimeToStr(now)+')';
  FreeAndNil(sl);

end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  timer1.Enabled := False;
  Checkforupdates(sender);
end;

procedure TForm1.actRenameUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled :=
    (TreeView1.Selected.ImageIndex in [0]);
end;

procedure TForm1.actRenameExecute(Sender: TObject);
begin
  TreeView1.Selected.EditText;
end;

procedure TForm1.actSaveConfigExecute(Sender: TObject);
begin
  StatusBar1.SimpleText := 'Saving Config';
  config.SaveXML(extractfilepath(paramstr(0))+'CONFIG.XML');
  StatusBar1.SimpleText := 'Config Saved';
end;

end.
