unit urllabel;
{
URLLabel Ver. 1.3.0.1
for Delphi 3 (It should work with D2 but I haven't tested it):
Developed by Filippo Passeggieri inspirated by some advices in
the UDDF site.
Initially, I thought to sell URLLabel at 250USD, but on second thought
I decided, being my first component, it had to be FREEWARE. :-)
If you have suggestions, bug reports please E-Mail me at:
   passeggieri@geocities.com

---------------------------------------------------------------------------
  ATTENTION!!!!!
  Use URLLabel component at your own risk!!! I decline any responsibility.
----------------------------------------------------------------------------

History:
26/12/97 - Corrected several bugs. - Ver 1.3.0.1
21/12/97 - Added effect like Win98/IE4 (property Effect98). - Ver 1.3.0.0
16/11/97 - Added support for FTP (property HTTPorMail is now called LabelType);
           Now cursor is browser-like. - Ver 1.2.0.0
06/11/97 - Corrected minor bugs. - Ver 1.1.0.0
04/11/97 - Added support to choose different colors if TURLLabel is pressed
           or not(properties SetColStd, SetColPre).
02/11/97 - Added support for Mail (property HTTPorMail).
31/10/97 - First release.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ShellApi;

type
  TLabelType = (hmHTTP, hmMAIL, hmFTP);

  TURLLabel = class(TCustomLabel)
  private
    { Private declarations }
    FLabelType: TLabelType;
    FColStd : TColor;
    FColPre : TColor;
    FEffect98: Boolean;
    procedure URLMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure URLMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure SetLabelType(Value: TLabelType);
    procedure SetColStd(Value: TColor);
    procedure SetColPre(Value: TColor);
    procedure SetEffect98(Value: Boolean);
  protected
    { Protected declarations }
    procedure Click; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
              X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
              X, Y: Integer); override;
  public
    { Public declarations }
    constructor Create( AOwner : TComponent); override;
    procedure OpenObject(sObjectPath : PChar);
  published
    { Published declarations }

    property LabelType : TLabelType
       read FLabelType
       write SetLabelType
       default hmHTTP;

    property URLColStd: TColor
       read FColStd
       write SetColStd
       default clBlue;

    property URLColPre: TColor
       read FColPre
       write SetColPre
       default clRed;

    property Effect98 : Boolean
       read FEffect98
       write SetEffect98
       default False;

    property Caption;
    property WordWrap;
    property Align;
    property Font;
    property AutoSize;
    property Alignment;
    property ParentFont;
    property Transparent;
    property Hint;
    property ShowHint;
  end;

procedure Register;

implementation

{$R URLLabel.res}

const
   crMyCursor = 25;
   HTTP = 'http:\\';
   MAIL = 'mailto:';
   FTP = 'ftp:\\';

constructor TURLLabel.Create( AOwner : TComponent);
begin
   inherited Create(AOwner);
   Screen.Cursors[crMyCursor] := LoadCursor(HInstance, 'URLHAND');
   Cursor := crMyCursor;
   Effect98 := false;
   URLColStd := clBlue;
   URLColPre := clRed;
   font.color := URLColStd;
   font.Style := [fsUnderline];
end;

procedure TURLLabel.URLMouseEnter(var Message: TMessage);
begin
   if Effect98 then
   begin
      font.color := URLColPre;
      font.Style := [fsUnderline];
      Invalidate
   end;
end;

procedure TURLLabel.URLMouseLeave(var Message: TMessage);
begin
   if Effect98 then
   begin
      font.color := URLColStd;
      font.Style := [];
      Invalidate
   end;
end;

procedure TURLLabel.SetEffect98(Value:Boolean);
begin
   if FEffect98 <> Value then
   begin
     FEffect98 := Value;
     if FEffect98 then font.Style := []
       else font.Style := [fsUnderline];
     Invalidate;
   end;
end;

procedure TURLLabel.SetLabelType;
begin
   if FLabelType <> Value then
   begin
      FLabelType := Value;
      Invalidate;
   end;
end;

procedure TURLLabel.SetColStd;
begin
   if FColStd <> Value then
   begin
     FColStd := Value;
     Font.Color := FColStd;
     Invalidate;
   end;
end;

procedure TURLLabel.SetColPre;
begin
   if FColPre <> Value then
   begin
     FColPre := Value;
     Invalidate;
   end;
end;

procedure TURLLabel.OpenObject(sObjectPath : PChar);
begin
   ShellExecute(0, Nil, sObjectPath, Nil, Nil, SW_NORMAL);
end;

procedure TURLLabel.Click;
var
  TempString : array[0..79] of char;
  szApp : string;
begin
   Inherited Click;
   if FLabelType = hmHTTP then szApp := HTTP
    else
      if FLabelType = hmFTP then  szApp := FTP
       else
         szApp := MAIL;
   StrPCopy(TempString,szApp+Caption);
   OpenObject(TempString);
end;

procedure TURLLabel.MouseDown(Button: TMouseButton; Shift: TShiftState;
              X, Y: Integer);
begin
   inherited MouseDown(Button,Shift,X,Y);
   if Button = mbLeft then font.color := URLColPre;
end;

procedure TURLLabel.MouseUp(Button: TMouseButton; Shift: TShiftState;
              X, Y: Integer);
begin
   inherited MouseUp(Button,Shift,X,Y);
   font.color := URLColStd;
end;

procedure Register;
begin
   RegisterComponents('Freeware', [ TURLLabel ]);
end;

end.
