unit IdStream;

interface

uses
  Classes;

type
  TIdStream = class(TStream)
  // IMPORTANT!!!!!!!!
  // NO data members may exist in this class
  // This class is used to "hackcast" a TStream to add functionality
  public
    function ReadLn: string;
    procedure Write(const AData: string); reintroduce;
    procedure WriteLn(const AData: string = '');
  end;

implementation

uses
  IdGlobal, IdTCPStream,
  SysUtils;

{ TIdStream }
function TIdStream.ReadLn: string;
//TODO: Continue to optimize this function. Its performance severely impacts
// the coders
var
  LBuf : String;
  LBufSize, LBufPos : Integer;
  LStrmPos, LStrmSize : Integer;

  procedure ReadBytes;
  // TODO: Dont access variable in parent proc, its very innefficient.
  // pass in as arguments or var arguments if they need to be changed.
  var
    ln: Integer;
  begin
    {We do not use fetch because it could incur a
    performance penalty with copy's range checking and
    because we have to know how many bytes to advance
    the stream position.  This will be the value in Ln}
    ln := IndyPos(LF, LBuf);
    if Ln >= LBufSize then begin
      Ln := LBufSize;
    end;
    SetLength(Result, Ln);
    Move(LBuf[LBufPos], Result[1], Ln);
    Inc(LStrmPos, Ln);
    Inc(LBufPos, Ln);
    Result := Trim(Result);
  end;

  procedure DeleteCR;
  var
    i: Integer;
  begin
    i := IndyPos(CR, Result);
    while i > 0 do begin
      Delete(Result, i, 1);
      i := IndyPos(CR, Result);
    end;
  end;

begin
  // 'is' does not work here - compiler error
  if InheritsFrom(TIdTCPStream) then begin
    Result := TIdTCPStream(Self).Connection.ReadLn;
  end else begin
    Result := '';
    LStrmPos := Position;
    LStrmSize := Size;
    LBufSize := LStrmSize - LStrmPos;
    if LBufSize > 0 then begin
      //TODO: What if the stream has 4M? This needs to be fixed.
      // Not only this, but it re reads each pass around.
      //This will kill performance
      SetLength(LBuf, LBufSize);
      ReadBuffer(LBuf[1], LBufSize);
      LBufPos := 1;
      //TODO: Why is ReadBytes a proc instead of just inline?
      ReadBytes;
      /// Why a proc and not inline?
      DeleteCR;
      Position := LStrmPos;
    end;
  end;
end;

procedure TIdStream.Write(const AData: string);
begin
  if Length(AData) > 0 then begin
    WriteBuffer(AData[1], Length(AData));
  end;
end;

procedure TIdStream.WriteLn(const AData: string = '');
begin
  Write(AData + EOL);
end;

end.
