package com.superhac.JXBStreamer.Gui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class SplashScreen {

	private JWindow jWindow = null;  //  @jve:decl-index=0:visual-constraint="187,60"
	private JPanel jContentPane = null;
	private JLabel jLabel = null;

	/**
	 * This method initializes jWindow	
	 * 	
	 * @return javax.swing.JWindow	
	 */
	public JWindow getJWindow() {
		if (jWindow == null) {
			jWindow = new JWindow();
			jWindow.setSize(new java.awt.Dimension(320,261));
			jWindow.setContentPane(getJContentPane());
			
			// custom
			Dimension dim =
	            Toolkit.getDefaultToolkit().getScreenSize();
	        int x = (int)(dim.getWidth() - jWindow.getWidth())/2;
	        int y = (int)(dim.getHeight() - jWindow.getHeight())/2;
	        jWindow.setLocation(x,y);
	        jWindow.setAlwaysOnTop(true);
		}
		return jWindow;
	}

	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(1);
			gridLayout.setColumns(1);
			jLabel = new JLabel();
			jLabel.setIcon(new ImageIcon(getClass().getResource("/com/superhac/JXBStreamer/Gui/images/splash.gif")));
			jLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
			jContentPane = new JPanel();
			jContentPane.setLayout(gridLayout);
			jContentPane.add(jLabel, null);
		}
		return jContentPane;
	}

}
