package com.superhac.JXBStreamer.Gui;

import java.awt.FlowLayout;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import java.awt.GridLayout;

public class SettingsWindow {

	private JDialog jDialog = null;  //  @jve:decl-index=0:visual-constraint="148,63"
	private JPanel jContentPane = null;
	private JTextField serverPortjTextField = null;
	private JPanel jPanel1 = null;
	private JLabel jLabel1 = null;

	 private boolean resetServer = false;
	//private String rootDir ="";
	private String port ="";
	private boolean autoDiscoveryEnabled= false;
	private JPanel jPanel = null;
	private JLabel jLabel = null;
	private JCheckBox jCheckBox = null;
	private JPanel jPanel2 = null;
	private JButton jButton = null;
	private JButton jButton1 = null;
	private JPanel jPanel3 = null;
	public SettingsWindow()
	 {
		 
	 }
	 
	 public SettingsWindow(String port, boolean autoDiscoveryEnabled)
	 {
		
		 this.port = port;
		 this.autoDiscoveryEnabled = autoDiscoveryEnabled;
	 }
	/**
	 * This method initializes jDialog	
	 * 	
	 * @return javax.swing.JDialog	
	 */
	public JDialog getJDialog(JFrame parent) {
		if (jDialog == null) {
			jDialog = new JDialog(parent, true); // parent, true
			jDialog.setTitle("Settings");
			jDialog.setPreferredSize(new java.awt.Dimension(200,300));
			jDialog.setMinimumSize(new java.awt.Dimension(200,300));
			jDialog.setSize(new java.awt.Dimension(287,162));
			jDialog.setContentPane(getJContentPane());
			
			jDialog.setLocationRelativeTo(parent);

		}
		return jDialog;
	}

	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BoxLayout(getJContentPane(), BoxLayout.Y_AXIS));
			jContentPane.setBackground(java.awt.Color.black);
			jContentPane.add(getJPanel3(), null);
			jContentPane.add(getJPanel2(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jTextField2	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getServerPortjTextField() {
		if (serverPortjTextField == null) {
			serverPortjTextField = new JTextField(port);
			serverPortjTextField.setColumns(6);
			serverPortjTextField.setForeground(new java.awt.Color(116,181,33));
			serverPortjTextField.setBackground(java.awt.Color.black);
		}
		return serverPortjTextField;
	}

	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel1() {
		if (jPanel1 == null) {
			FlowLayout flowLayout = new FlowLayout();
			flowLayout.setAlignment(java.awt.FlowLayout.LEFT);
			jLabel1 = new JLabel();
			jLabel1.setText("Server Port:");
			jLabel1.setForeground(new java.awt.Color(116,181,33));
			jLabel1.setBackground(java.awt.Color.black);
			jPanel1 = new JPanel();
			jPanel1.setBackground(java.awt.Color.black);
			jPanel1.setLayout(flowLayout);
			
			
			jPanel1.add(jLabel1, null);
			jPanel1.add(getServerPortjTextField(), null);
		}
		return jPanel1;
	}

	public boolean isResetServer() {
		return resetServer;
	}
	
	public int getPort()
	{
		return Integer.parseInt(serverPortjTextField.getText());
	}
	public boolean isAutoDiscoveryEnabled()
	{
		return jCheckBox.isSelected();
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			FlowLayout flowLayout2 = new FlowLayout();
			flowLayout2.setAlignment(java.awt.FlowLayout.LEFT);
			flowLayout2.setVgap(5);
			jLabel = new JLabel();
			jLabel.setText("Enable Auto Discovery?");
			jLabel.setForeground(new java.awt.Color(116,181,33));
			jLabel.setBackground(java.awt.Color.black);
			jPanel = new JPanel();
			jPanel.setBackground(java.awt.Color.black);
			jPanel.setLayout(flowLayout2);
			jPanel.add(jLabel, null);
			jPanel.add(getJCheckBox(), null);
		}
		return jPanel;
	}

	/**
	 * This method initializes jCheckBox	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJCheckBox() {
		if (jCheckBox == null) {
			jCheckBox = new JCheckBox();
			jCheckBox.setSelected(autoDiscoveryEnabled);
			jCheckBox.setForeground(new java.awt.Color(116,181,33));
			jCheckBox.setBackground(java.awt.Color.black);
		}
		return jCheckBox;
	}

	/**
	 * This method initializes jPanel2	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel2() {
		if (jPanel2 == null) {
			FlowLayout flowLayout1 = new FlowLayout();
			flowLayout1.setAlignment(FlowLayout.RIGHT);
			jPanel2 = new JPanel();
			jPanel2.setBackground(java.awt.Color.black);
			jPanel2.setLayout(flowLayout1);
			jPanel2.add(getJButton(), null);
			jPanel2.add(getJButton1(), null);
		}
		return jPanel2;
	}

	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton() {
		if (jButton == null) {
			jButton = new JButton();
			jButton.setText("OK");
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					resetServer = true;
					jDialog.dispose();
				}
			});
			
		}
		return jButton;
	}

	/**
	 * This method initializes jButton1	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton1() {
		if (jButton1 == null) {
			jButton1 = new JButton();
			jButton1.setText("Cancel");
			jButton1.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					jDialog.dispose();
				}
			});
		}
		return jButton1;
	}

	/**
	 * This method initializes jPanel3	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel3() {
		if (jPanel3 == null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(2);
			gridLayout.setColumns(1);
			jPanel3 = new JPanel();
			jPanel3.setBackground(java.awt.Color.black);
			jPanel3.setLayout(gridLayout);
			jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Server Settings", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), new java.awt.Color(116,181,33)));
			jPanel3.add(getJPanel1(), null);
			jPanel3.add(getJPanel(), null);
		}
		return jPanel3;
	}
}  //  @jve:decl-index=0:visual-constraint="45,45"
