package com.superhac.JXBStreamer.Gui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.util.Timer;
import java.util.TimerTask;

import javax.swing.JPanel;
import javax.swing.JTextField;

import com.superhac.JXBStreamer.Core.XBMSPServer;
import javax.swing.JLabel;

public class MainStatusBar {
	
	private XBMSPServer server;
	private JPanel jPanel = null;  //  @jve:decl-index=0:visual-constraint="360,133"
	private JTextField serverStatusjTextField = null;
	private JLabel jLabel = null;
	public MainStatusBar(XBMSPServer server)
	{
		this.server = server;
		
		// update every second
		Timer timer = new Timer();
        timer.scheduleAtFixedRate(new RemindTask(this), 1000, 1000);
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	public JPanel getJPanel() {
		if (jPanel == null) {
			jLabel = new JLabel();
			jLabel.setText("Server Status:");
			jLabel.setForeground(new java.awt.Color(116,181,33));
			jLabel.setBackground(java.awt.Color.black);
			FlowLayout flowLayout = new FlowLayout();
			flowLayout.setAlignment(java.awt.FlowLayout.LEFT);
			jPanel = new JPanel();
			jPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.RAISED));
			jPanel.setBackground(java.awt.Color.black);
			jPanel.setLayout(flowLayout);
			jPanel.add(jLabel, null);
			jPanel.add(getJTextField1(), null);
		}
		return jPanel;
	}
	
	public void update(){
		
		if(server.isServerRunning())
		{
			serverStatusjTextField.setForeground(new Color(0x05BF4B));
			serverStatusjTextField.setText("Running..");
		}
		else
		{
			serverStatusjTextField.setForeground(Color.RED);
			serverStatusjTextField.setText("Stopped");
		}
		// when the text changes this makes the jTextField resize
		jPanel.revalidate();
		
	}
	
	class RemindTask extends TimerTask {

    	
    	MainStatusBar caller;

        RemindTask(MainStatusBar caller) {
        	this.caller = caller;
           
        }

        public void run() {

        	
        		caller.update();
        		
        		

        }
	}

	/**
	 * This method initializes jTextField1	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextField1() {
		if (serverStatusjTextField == null) {
			serverStatusjTextField = new JTextField();
			serverStatusjTextField.setEditable(false);
			serverStatusjTextField.setBorder(null);
			serverStatusjTextField.setToolTipText("Is the server running?");
			serverStatusjTextField.setBackground(java.awt.Color.black);
			serverStatusjTextField.setForeground(new java.awt.Color(116,181,33));
			serverStatusjTextField.setText("-----");
		}
		return serverStatusjTextField;
	}
}
