/*
 * Decompiled with CFR 0.152.
 */
package com.superhac.JXBStreamer.Core;

import com.superhac.JXBStreamer.Core.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class FileHandlerObject {
    private int handle;
    private File file;
    private long maxPosition;
    private long currentFilePosition;
    private long fileTransferBytes = 0L;
    private long startTime;
    private RandomAccessFile fstream;
    private static Logger logger;

    protected FileHandlerObject(int handle, File file) {
        this.handle = handle;
        this.file = file;
        this.startTime = System.currentTimeMillis();
        try {
            this.fstream = new RandomAccessFile(file, "r");
            this.currentFilePosition = this.fstream.getFilePointer();
            this.maxPosition = this.fstream.length();
        }
        catch (FileNotFoundException e) {
            System.out.println("Should not have happend(FIleHandler): " + e);
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("Should not have happend(FIleHandler): " + e);
            System.exit(1);
        }
        logger = Debug.getLogger();
    }

    protected ByteBuffer read(int numberOfBytes) {
        if (Debug.debug) {
            logger.info("Reading and packing file data. Read bytes req: " + numberOfBytes + " Current POS: " + this.currentFilePosition + " Max Pos: " + this.maxPosition);
        }
        try {
            byte[] data = new byte[numberOfBytes];
            int bytesRead = this.fstream.read(data);
            ByteBuffer buf = ByteBuffer.allocate(20000);
            if (bytesRead == -1) {
                if (Debug.debug) {
                    logger.info("End of File... Sending null. Current POS: " + this.currentFilePosition + " Max Pos: " + this.maxPosition);
                }
                return null;
            }
            this.currentFilePosition = this.fstream.getFilePointer();
            this.fileTransferBytes += (long)bytesRead;
            buf.putInt(bytesRead);
            return buf.put(data, 0, bytesRead);
        }
        catch (IOException e) {
            System.out.println("Should not have happend(FIleHandler read): " + e);
            System.exit(1);
            return null;
        }
    }

    protected boolean seekFile(long offset, byte seekType) {
        if (Debug.debug) {
            logger.info("Seeking file data: offset: " + offset + " SeekType:" + seekType + " Current POS: " + this.currentFilePosition + " Max Pos: " + this.maxPosition);
        }
        boolean error = false;
        try {
            switch (seekType) {
                case 0: {
                    if (offset <= this.maxPosition) {
                        this.fstream.seek(offset);
                        break;
                    }
                    error = true;
                    break;
                }
                case 1: {
                    long newOffset = this.maxPosition - offset;
                    if (newOffset >= 0L && newOffset <= this.maxPosition) {
                        this.fstream.seek(newOffset);
                        break;
                    }
                    error = true;
                    break;
                }
                case 2: {
                    long newOffset = this.currentFilePosition + offset;
                    if (newOffset <= this.maxPosition) {
                        this.fstream.seek(newOffset);
                        break;
                    }
                    error = true;
                    break;
                }
                case 3: {
                    long newOffset = this.currentFilePosition - offset;
                    if (newOffset >= 0L) {
                        this.fstream.seek(newOffset);
                        break;
                    }
                    error = true;
                    break;
                }
                default: {
                    error = true;
                    break;
                }
            }
        }
        catch (IOException e) {
            System.out.println("Should not have happend(FIleHandler seek): " + e);
            System.exit(1);
        }
        return error;
    }

    protected String getFileName() {
        return this.file.getName();
    }

    protected File getFile() {
        return this.file;
    }

    protected int getHandle() {
        return this.handle;
    }

    protected long getFileTransferRate() {
        long duration = (System.currentTimeMillis() - this.startTime) / 1000L;
        long bytesPerSec = 0L;
        if (this.fileTransferBytes > 0L && duration > 0L) {
            bytesPerSec = this.fileTransferBytes / duration;
        }
        return bytesPerSec;
    }
}

