/*   -*- c -*-
 * 
 *  ----------------------------------------------------------------------
 *  CcXstream Server for XBOX Media Player
 *  ----------------------------------------------------------------------
 *
 *  Copyright (c) 2002-2003 by PuhPuh
 *  
 *  This code is copyrighted property of the author.  It can still
 *  be used for any non-commercial purpose following conditions:
 *  
 *      1) This copyright notice is not removed.
 *      2) Source code follows any distribution of the software
 *         if possible.
 *      3) Copyright notice above is found in the documentation
 *         of the distributed software.
 *  
 *  Any express or implied warranties are disclaimed.  Author is
 *  not liable for any direct or indirect damages caused by the use
 *  of this software.
 *
 *  ----------------------------------------------------------------------
 *
 */


#ifndef CC_XSTREAM_H_INCLUDED
#define CC_XSTREAM_H_INCLUDED 1

#include "ccxversion.h"
#include "ccxpacket.h"
#include "ccxencode.h"

typedef struct CcXstreamConfigurationOptionRec *CcXstreamConfigurationOption;
typedef struct CcXstreamConnectionRec *CcXstreamConnection;
typedef struct CcXstreamProgRec *CcXstreamProg;
typedef struct CcXstreamShareRec *CcXstreamShare;

#define CC_XSTREAM_HANDLE_DIR   1
#define CC_XSTREAM_HANDLE_FILE  2

#define CC_XSTREAM_MAX_OPEN_FILES 8

struct CcXstreamConfigurationOptionRec {
  char *name;
  char *itemname;
  char *info;
  char *value;
  char readonly;
  CcStringList legal_values;
  CcXstreamConfigurationOption next;
};

struct CcXstreamShareRec {
  CcXstreamShare next;
  char *mountpoint;
  char *dir;
};

struct CcXstreamConnectionRec {
  int s;
  char *cwd;
  char *fn;
  int remote_version;
  unsigned char *outbuf;
  size_t outbuf_len;
  unsigned char *inbuf;
  size_t inbuf_len;
  unsigned long open_file_handle[CC_XSTREAM_MAX_OPEN_FILES];
  FILE *f[CC_XSTREAM_MAX_OPEN_FILES];
  off_t end_offset[CC_XSTREAM_MAX_OPEN_FILES];
  unsigned long open_dir_handle;
  char *open_dir_cwd;
  unsigned long open_auth_handle;
  char *open_auth_method;
  char authenticated;
  CcXstreamProg prog;
  CcXstreamConnection next;
  CcStringList dirfile;
  CcXstreamConfigurationOption configuration;
};

struct CcXstreamProgRec {
  int s;
  int bs;
  char *rootdir;
  int localport;
  char *localaddr;
  char remoteconf;
  char *user_id;
  char *user_password;
  char *server_comment;
  int daemonize;
  int follow_symlinks;
  int discovery_limit;
  char *pidfile;
  CcXstreamShare shares;
  CcXstreamConnection connection;
  CcXstreamConfigurationOption configuration;
};

CcXstreamConnection cc_xstream_connection_allocate(void);
void cc_xstream_connection_free(CcXstreamConnection conn);
int cc_xstream_consume_input(CcXstreamConnection conn);
int cc_xstream_handle_packet(CcXstreamConnection conn, const unsigned char *packet, size_t len);
int cc_xstream_parse_remote_version(CcXstreamConnection conn, const char *proto);
void cc_xstream_write_string(CcXstreamConnection conn, const char *string);
void cc_xstream_write_data(CcXstreamConnection conn, const unsigned char *data, size_t len);
void cc_xstream_write_data_string(CcXstreamConnection conn, const unsigned char *data, size_t len);
void cc_xstream_write_int(CcXstreamConnection conn, unsigned long n);
void cc_xstream_write_byte(CcXstreamConnection conn, unsigned char b);
void cc_xstream_send_ok(CcXstreamConnection conn, unsigned long id);
void cc_xstream_send_handle(CcXstreamConnection conn, unsigned long id, unsigned long handle);
void cc_xstream_send_error(CcXstreamConnection conn, unsigned long id, CcXstreamError error, const char *msg);
void cc_xstream_make_non_blocking(int s);
CcStringList cc_xstream_read_directory(const char *path);
CcStringList cc_xstream_string_list_add(CcStringList lst, const char *str);
char *cc_xstream_file_info(CcXstreamProg prog, const char *path, const char *relativepath);
int cc_xstream_path_is_directory(CcXstreamProg prog, const char *path);
int cc_xstream_path_is_file(CcXstreamProg prog, const char *path);
off_t cc_xstream_open_file_size(FILE *f);
off_t cc_xstream_file_size(const char *path);

#define CC_XSTREAM_PROTOCOL_INIT        "XBMSP-1.0 1.0 CcXstream Media Server " \
                                        CC_XSTREAM_SW_VERSION
#define CC_XSTREAM_VERSION_STRING       "CcXstream Media Server " CC_XSTREAM_SW_VERSION
#define CC_XSTREAM_CONFIG_DIR_ITEM_NAME "configuration"
#define CC_XSTREAM_CONFIG_DIR_NAME      "Server Configuration"
#define CC_XSTREAM_CONFIG_DIR_INFO      "Various settings for CcXstream"

#endif /* CC_XSTREAM_H_INCLUDED */
/* eof (ccxstream.h) */
