/*   -*- c -*-
 * 
 *  ----------------------------------------------------------------------
 *  Debugging stuff.
 *  ----------------------------------------------------------------------
 *
 *  Copyright (c) 2002-2003 by PuhPuh
 *  
 *  This code is copyrighted property of the author.  It can still
 *  be used for any non-commercial purpose following conditions:
 *  
 *      1) This copyright notice is not removed.
 *      2) Source code follows any distribution of the software
 *         if possible.
 *      3) Copyright notice above is found in the documentation
 *         of the distributed software.
 *  
 *  Any express or implied warranties are disclaimed.  Author is
 *  not liable for any direct or indirect damages caused by the use
 *  of this software.
 *
 *  ----------------------------------------------------------------------
 *
 */

#include "ccincludes.h"

static char *debug_file = NULL;
static int debug_line = 0;
static int debug_level = 0;

void cc_debug_set_level(int level)
{
  debug_level = level;
}

int cc_debug_level(void)
{
  return debug_level;
}

void cc_debug_set_source_offset(const char *file, int line)
{
  cc_xfree(debug_file);
  debug_file = cc_xstrdup(file);
  debug_line = line;
}

void cc_debug_printf(const char *format, ...)
{
  va_list ap;

  if (debug_file != NULL)
    fprintf(stderr, "DEBUG %s:%d ", debug_file, debug_line);
  else
    fprintf(stderr, "DEBUG ??? ");
  va_start(ap, format);
  vfprintf(stderr, format, ap);  
  va_end(ap);
  fprintf(stderr, "\n");
}

/* eof (ccdebug.c) */
