#pragma once
#include "COsEvent.h"
#include "CCriticalSection.h"

class CThread;

/////////////////////////////////////////////////////////////////////////////////////////////
//
//		Defines an object that runs in it's own thread.  There are two uses:
//			1. The objects lifetime is controlled by the thread.  Used this way the runnable
//				is constructed on the heap and self deletes when it's run function returns.
//				It is not possible to externally stop the thread, it must exit
//			2. The object's lifetime is not controlled by the thread, i.e. the object can 
//				exist before the thread is started and after the thread has terminated.  It 
//				is even possible to restart the object in a new	thread after it's thread has 
//				terminated.  In this mode the object is usually a member of another object.
//

class CRunnable
{
	public:
		CRunnable( bool bAutoDelete );
		virtual ~CRunnable();
		
		void Invoke( void );
		bool Start( CThread* pThread = 0 );
		bool Pause( void );
		bool Resume( void );
		bool Stop( void );

		bool IsRunning( void )
			{ return m_bRun; }

	protected:
		CThread*			m_pThread;
		COsEvent			m_RunningEvent;
		COsEvent			m_StoppedEvent;
		CCriticalSection	m_ShutDownSection;
		bool				m_bRun;
		bool				m_bPaused;
		bool				m_bAutoDelete;

		virtual bool HandlePreRun( void )=0;
		virtual void HandleRun( void )=0;
		virtual void HandleStop( void )=0;
		virtual void HandlePostRun( void )=0;

		friend class CThread;

	private:
		void Run( void );
};

