/////////////////////////////////////////////////////////////////////////////////////////////
//
#include "stdafx.h"
#include "XDebugServer.h"
#include "CString.h"
#include "CTrace.h"

/////////////////////////////////////////////////////////////////////////////////////////////
//
XDebugServer::XDebugServer
(
	int iPort
)
	:
	CNTService( TEXT( "XDebugServer" ), TEXT( "XBox Debug Message Server" ) ),
	m_SocketEvents( 2 ),
	m_iPort( iPort ),
	m_pClientSocket( NULL ),
	m_bIsInitialized( false ),
	m_bIsActive( false )
{
	CStringEx sBuffer;
	sBuffer.Format( "XDebugServer initialized on port %i\n", m_iPort );

	::OutputDebugString( sBuffer.c_str() );
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
XDebugServer::~XDebugServer()
{
	::OutputDebugString( "XDebugServer shutting down\n" );
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
bool XDebugServer::HandlePreRun( void )
{
	return 
	(
		m_ServerSocket.EventSelect( FD_ACCEPT | FD_CLOSE ) &&
		m_ServerSocket.Listen( NULL, m_iPort, SOMAXCONN )
	);
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
void XDebugServer::HandleRun( void )
{
	CWaitable* pWaitable = NULL;
	CSocket* pSocket = NULL;

	while ( m_ssStatus.dwCurrentState == SERVICE_RUNNING )
	{
		// Init the select
		m_SocketEvents.Reset();

		// Add the server socket
		m_SocketEvents.Add( &m_ServerSocket );

		// Add the client sockets
		if ( m_pClientSocket )
			m_SocketEvents.Add( m_pClientSocket );

		// Wait for something to happen
		pWaitable = m_SocketEvents.Wait( INFINITE, FALSE );

		// Make sure that we should keep running
		if ( m_ssStatus.dwCurrentState != SERVICE_RUNNING )
			break;

		pSocket = dynamic_cast< CSocket* >( pWaitable );

		if ( pSocket )
			OnEvent( pSocket );
		else
			break;
	}
}


/////////////////////////////////////////////////////////////////////////////////////////////
//
void XDebugServer::HandleStop( void )
{
	m_ServerSocket.Close();
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
void XDebugServer::HandlePostRun( void )
{
	m_ServerSocket.Close();
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
void XDebugServer::OnEvent
( 
	CSocket* pSocket 
)
{
	DWORD dwEvents = 0;

	if ( pSocket->GetSignaledEvent( dwEvents ) )
	{
		// Run the procedure corresponding to the signalled event
		if ( dwEvents & FD_ACCEPT )
			HandleSocketAccept( pSocket );

		if ( dwEvents & FD_READ )
			HandleSocketRead( pSocket );

		if ( dwEvents & FD_WRITE )
			HandleSocketWrite( pSocket );

		if ( dwEvents & FD_CLOSE )
			HandleSocketClose( pSocket );
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
void XDebugServer::HandleSocketAccept
( 
	CSocket* pSocket 
)
{
	CSocket* pClientSocket = NULL;

	if ( m_ServerSocket.Accept( pClientSocket ) )
	{
		// Nuke any existing connection as it is probably stale
		if ( m_pClientSocket )
		{
			m_pClientSocket->Close();
			HandleSocketClose( m_pClientSocket );
		}

		int iIpAddress = pClientSocket->GetPeerIpAddress();
		pClientSocket->ConvertIpAddress( iIpAddress, m_sClientIpAddr );
		pClientSocket->EventSelect( FD_READ | FD_CLOSE );
		m_pClientSocket = pClientSocket;

		CStringEx sBuffer;
		sBuffer.Format( "Connection accepted from %s\n", m_sClientIpAddr.c_str() );

		::OutputDebugString( sBuffer.c_str() );
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
void XDebugServer::HandleSocketRead
( 
	CSocket* pSocket 
)
{
	// Read the data in
	int iBytesReceived, iPosition = 0;
	static const int iBufferSize = 1024;
	static char buffer[ iBufferSize ];
	char* pszBuffer = buffer;
	bool bResult = false;

	if ( pSocket->Receive( pszBuffer, iBufferSize, iBytesReceived ) )
	{
		pszBuffer[ iBytesReceived ] = 0;

		// Now send it right out the debug port
		::OutputDebugString( pszBuffer );
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
void XDebugServer::HandleSocketWrite
( 
	CSocket* pSocket 
)
{
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
void XDebugServer::HandleSocketClose
( 
	CSocket* pSocket 
)
{
	if ( pSocket == m_pClientSocket )
	{
		CStringEx sBuffer;
		sBuffer.Format( "Disconnet received from %s\n", m_sClientIpAddr.c_str() );

		::OutputDebugString( sBuffer.c_str() );

		delete m_pClientSocket;
		m_pClientSocket = NULL;
	}
}
