#pragma once

#if ( USE_XTRACE == 1 || USE_XERROR == 1 )

#include "XCriticalSection.h"
#include <xbsocket.h>

/////////////////////////////////////////////////////////////////////////////////////////////
//
//	Implementation of the debug trace class.
//
class XTraceClient
{
	public:
		~XTraceClient();

		// Singleton access
		static XTraceClient* Instance( void );

		// Static cleanup method
		static void Cleanup( void );

		// Connect to the defined PC
		void Connect( const char* pszIpAddress, const int iIpPort );

		// Close the connection to the PC
		void Close( void );

		// Trace output to local and remote debugger using printf formatting
		void TraceVA( const char* pszFormat, va_list argList );

	private:
		CXBSocket				m_Socket;
		XCriticalSection		m_CriticalSection;
		bool					m_bConnected;
		const int				m_iBufferLength;
		char*					m_pszBuffer;
		static XTraceClient*	m_pInstance;

		// Protect the constructor: use XTraceClient::Instance()->Fn()
		XTraceClient();

		// Send to remote PC
		void Send( const char* pszMessage );
};

#endif

