#pragma once

/////////////////////////////////////////////////////////////////////////////////////////////
//
//	Set these to 1 to have trace messages expand into code.
//
#define USE_XTRACE 0
#define USE_XERROR 0

/////////////////////////////////////////////////////////////////////////////////////////////
//
//	Define the XTRACE macro.  If USE_XTRACE is 1 then the trace messages will compile
//	and execute.  If USE_XTRACE is 0 then the XTRACE code will not be compiled or 
//	executed.
//
#if ( USE_XTRACE == 1 )
	#ifdef __cplusplus
	extern "C" void _XTrace( const char* pszFormat, ... );
	#else
	void _XTrace( const char* pszFormat, ... );
	#endif
	#define XTRACE				_XTrace
#else
	inline void _XTrace( const char* pszFormat, ... ){}
	#define XTRACE              1 ? (void)0 : _XTrace
#endif

/////////////////////////////////////////////////////////////////////////////////////////////
//
//	Define the XERROR macro.  If USE_XERROR is 1 then the trace messages will compile
//	and execute.  If USE_XERROR is 0 then the XERROR code will not be compiled or 
//	executed.
//
#if ( USE_XERROR == 1 )
	#ifdef __cplusplus
	extern "C" void _XError( const char* pszFormat, ... );
	#else
	void _XError( const char* pszFormat, ... );
	#endif
	#define XERROR				_XError
#else
	inline void _XError( const char* pszFormat, ... ){}
	#define XERROR              1 ? (void)0 : _XError
#endif

/////////////////////////////////////////////////////////////////////////////////////////////
//
//	Define the XDEBUGINIT and XDEBUGCLEANUP macros.  Use this to start and stop the 
//	XDebugClient remote logger.
//
#if ( USE_XTRACE == 1 || USE_XERROR == 1 )
	#ifdef __cplusplus
	extern "C" void _XDebugInit( const char* pszIpAddress, const int iIpPort );
	extern "C" void _XDebugCleanup( void );
	#else
	void _XDebugInit( const char* pszIpAddress, const int iIpPort );
	void _XDebugCleanup( void );
	#endif

	#define XDEBUGINIT					_XDebugInit
	#define XDEBUGCLEANUP				_XDebugCleanup
#else
	inline void _XDebugInit( const char* pszIpAddress, const int iIpPort ){}
	inline void _XDebugCleanup( void ){}

	#define XDEBUGINIT              1 ? (void)0 : _XDebugInit
	#define XDEBUGCLEANUP              1 ? (void)0 : _XDebugCleanup
#endif
