#pragma once
#define _WIN32_WINNT 0x0400
#include <windows.h>

/////////////////////////////////////////////////////////////////////////////////////////////
//
//		This class is a mixin interface for objects supporting thread synchronization.  The 
//		Wait function checks the current state of the specified object.  If the object's 
//		state is nonsignaled, the calling thread enters an efficient wait state. The thread 
//		consumes very little processor time while waiting for the object state to become 
//		signaled or the time-out interval to elapse.
//
//		Synchronizing a thread across multiple CWaitable instances is supported by the 
//		CWaitableCollection class.
// 

class CWaitable
{
	public:
		CWaitable();
		virtual ~CWaitable();
		
		DWORD Wait( DWORD dwMilliseconds = INFINITE );
		virtual HANDLE GetWaitHandle( void )=0;
		virtual void CancelWait( void )=0;
};

/////////////////////////////////////////////////////////////////////////////////////////////
//
//		This class supports synchronizing a thread across multiple CWaitable instances.
//

class CWaitableCollection
{
	public:
		CWaitableCollection( int iMaxSize );
		virtual ~CWaitableCollection();
		
		CWaitable* Wait( DWORD dwMilliseconds = INFINITE, bool bWaitAll = true );
		bool Add( CWaitable* pWaitable );
		void Reset( void )
			{ m_iSize = 0; }
		void Cancel( void );

	private:
		int				m_iMaxSize;		// The max size of the collection.
		int				m_iSize;		// The current size of the collection.
		HANDLE*			m_pHandles;		// Pointer to an array of OS handles.
		CWaitable**		m_pObjects;		// Pointer to an array of CWaitable pointers.
};

