#pragma once
#define _WIN32_WINNT 0x0400
#include <windows.h>
#include "CWaitable.h"

/////////////////////////////////////////////////////////////////////////////////////////////
//
//		Encapsulate the functions associated with a windows event object.
//

class COsEvent : public CWaitable
{
	public:
		COsEvent
		(
			bool bManualReset = false,		// flag for manual-reset event
			bool bInitialState = false		// flag for initial state
		)
			{ m_hEvent = ::CreateEvent( 0, bManualReset, bInitialState, 0 ); }
  
		virtual ~COsEvent()
			{ ::CloseHandle( m_hEvent ); }

		// put into signaled state
		void Signal( void )
			{ ::SetEvent( m_hEvent ); }

		void Clear( void )
			{ ::ResetEvent( m_hEvent ); }

		operator HANDLE()
			{ return m_hEvent; }

		virtual HANDLE GetWaitHandle( void )
			{ return m_hEvent; }

		virtual void CancelWait( void )
			{ Signal(); }

	private:
		HANDLE			m_hEvent;		// Handle to the underlying OS event object.
};

