#include "stdafx.h"
#include "CFormatBuffer.h"

/////////////////////////////////////////////////////////////////////////////////////////////
//
CFormatBuffer::CFormatBuffer
(
	unsigned int nMaxLength
)
	:
	m_pszBuffer( NULL ),
	m_nMaxLength( nMaxLength )
{
	m_pszBuffer = new char[ m_nMaxLength + 1];
	memset( m_pszBuffer,'\0',m_nMaxLength + 1 );
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
CFormatBuffer::~CFormatBuffer()
{
	delete[] m_pszBuffer;
	m_pszBuffer = 0;
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
int CFormatBuffer::available() const
{
	return m_nMaxLength - getLength();
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
void CFormatBuffer::ensureCapacity
(
	int iAmount,
	int incrSize
)
{
	int nAvail = available();

	if ( nAvail < iAmount )
	{
		iAmount = iAmount - nAvail;

		if ( incrSize == -1 )
			incrSize = m_nMaxLength;

		if ( incrSize > iAmount )
			iAmount = incrSize;

		expand( iAmount );
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
void CFormatBuffer::expand
(
	int iAmount
)
{
	if ( iAmount == -1 )
		iAmount = m_nMaxLength;

	char *pNewBuf = new char[ m_nMaxLength + iAmount + 1 ];
	memcpy( pNewBuf, m_pszBuffer, m_nMaxLength );
	delete[] m_pszBuffer;

	memset( pNewBuf + m_nMaxLength, '\0', iAmount + 1 );
	m_pszBuffer = pNewBuf;
	m_nMaxLength += iAmount;
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
int CFormatBuffer::format
(
	const char* pszFormat,
	...
)
{
	int iLength;
	va_list argList;
	va_start( argList, pszFormat );

	iLength = _format( m_pszBuffer, pszFormat, argList );

	va_end( argList );

	return iLength;
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
int CFormatBuffer::format
(
	const char* pszFormat,
	va_list argList
)
{
	return vsprintf( m_pszBuffer, pszFormat, argList );
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
int CFormatBuffer::appendString
( 
	const char* pszData,
	int incrSize 
)
{
	if ( pszData != NULL )
	{
		int len = strlen( pszData );
		ensureCapacity( len, incrSize );
		return append( "%s", pszData );
	}

	return 0;
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
int CFormatBuffer::append
(
	const char* pszFormat,
	...
)
{
	int iLength;
	va_list argList;
	va_start( argList, pszFormat );

	// Figure out where to start from
	int iStart = strlen( m_pszBuffer );

	iLength = _format( m_pszBuffer + iStart, pszFormat, argList );

	va_end( argList );

	return iLength;
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
int CFormatBuffer::append
(
	const char* pszFormat,
	va_list argList
)
{
	// Figure out where to start from
	int iStart = strlen( m_pszBuffer );
	int iLength = _format( m_pszBuffer + iStart, pszFormat, argList );

	return iLength;
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
void CFormatBuffer::empty( void )
{
	m_pszBuffer[ 0 ] = 0;
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
const char* CFormatBuffer::toString( void ) const
{
	return m_pszBuffer;
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
char* CFormatBuffer::data( void )
{
	return &m_pszBuffer[0];
}


/////////////////////////////////////////////////////////////////////////////////////////////
//
int CFormatBuffer::getLength( void ) const
{
	return strlen( m_pszBuffer );
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
void CFormatBuffer::toString
(
	CStringEx& sString
)
	const
{
	sString = m_pszBuffer;
}

/////////////////////////////////////////////////////////////////////////////////////////////
//
int CFormatBuffer::_format
(
	char* pszBuffer,
	const char* pszFormat,
	va_list argList
)
{
	return vsprintf( pszBuffer, pszFormat, argList );
}
