// debugserverDlg.cpp : implementation file
//

#include "stdafx.h"
#include "debugserver.h"
#include "debugserverDlg.h"
#include "DlgKeyAccept.h"
#include "tcp4u.h"
#include <mmsystem.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define ERROR_DT_TIMEOUT		1
#define ERROR_DT_BAD_REQUEST	2
#define ERROR_DT_NO_FILES		3
#define ERROR_DT_MAX_WORDS		4
#define ERROR_DT_GENERAL		5
#define ERROR_DT_NONE			6


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

CRITICAL_SECTION m_critSection ;

typedef struct SOCK_AND_WIN {
	SOCKET	*sock ;
	CWnd	*wnd ;
} sockAndWinStruct ;

void WriteMessage( CdebugserverDlg *dlg, SOCKET *socket, char *message)
{
	EnterCriticalSection(&m_critSection) ;

	CString cstrMessages ;
	CString cstrSocket ;
	char    szBuf[30] ;

	dlg->m_edMessages.GetWindowText(cstrMessages) ;

	_strtime(szBuf) ;

	if (socket != NULL)
	{
		cstrSocket.Format("%s socket=%8.8X, ", szBuf, socket) ;
		cstrMessages += cstrSocket ;
	}

	cstrMessages += message ;
	cstrMessages = cstrMessages.Right(64*1024) ;
	dlg->m_edMessages.SetWindowText(cstrMessages) ;
	if (((dlg->m_edMessages.GetLineCount() - dlg->m_edMessages.GetFirstVisibleLine()) - dlg->m_nuiNumVisibleLines)>0)
		dlg->m_edMessages.LineScroll(((dlg->m_edMessages.GetLineCount() - dlg->m_edMessages.GetFirstVisibleLine()) - dlg->m_nuiNumVisibleLines), 0) ;

	dlg->m_edMessages.UpdateWindow();

	LeaveCriticalSection(&m_critSection) ;
}

UINT DebugClientRequestThread( LPVOID pParam )
{
	int           Rc;
	char          *waitstr ;
	char	      szBuf[64*1024] ;
	CString       cstrMessage ;
	char          szStationName[64];
	char          szIPAddress[16] ;
	DWORD         dwIPAddress;
	unsigned char *cAdd = (unsigned char *) &dwIPAddress;
	CTime         searchTimeBegin ;
	DWORD         totalTimeBegin ;

	totalTimeBegin = timeGetTime() ;

	sockAndWinStruct  *sw = (sockAndWinStruct*) pParam ;
	SOCKET *CSock = sw->sock ;
	CdebugserverDlg *dlg = (CdebugserverDlg*)sw->wnd;

	TcpGetRemoteID (*CSock, szStationName, sizeof szStationName, &dwIPAddress);
	sprintf (szIPAddress, "%u.%u.%u.%u", cAdd[0], cAdd[1], cAdd[2], cAdd[3]);

	cstrMessage = "Initiated communication with " ;
	cstrMessage += szIPAddress ;
	cstrMessage += "\r\n" ;
	WriteMessage(dlg, CSock, (char*)(LPCTSTR)cstrMessage) ;

	while ( 1 )
	{
		Rc = TcpRecv(*CSock, szBuf, 64*1024, TCP4U_DONTWAIT, HFILE_ERROR);

		if ( Rc == TCP4U_TIMEOUT )
			continue ;
		else if (Rc<TCP4U_SUCCESS)
		{
			cstrMessage = "Error while trying to read information from client - connection probably closed" ;
			cstrMessage += szIPAddress ;
			cstrMessage += "\r\n" ;
			WriteMessage(dlg, CSock, (char*)(LPCTSTR)cstrMessage) ;
			break ;
		}

		szBuf[Rc] = 0 ;

		if ( ( waitstr = strstr( szBuf, "**WAITKEY**" ) ) != NULL )
		{

			*waitstr = 0 ;

			if ( szBuf[strlen(szBuf)-1] != '\n' )
				strcat( szBuf, "\r\n" ) ;

			WriteMessage( dlg, CSock, szBuf ) ;

			dlg->cKeyDlg.DoModal() ;
			
			Rc = TcpSend(*CSock, &(dlg->cKeyDlg.m_ch), 1, false, HFILE_ERROR);

		}
		else
		{
			szBuf[Rc] = 0 ;
			if ( szBuf[Rc-1] != '\n' )
				strcat( szBuf, "\r\n" ) ;
			WriteMessage( dlg, CSock, szBuf ) ;
		}
	}

	TcpClose ( CSock);

	delete CSock ;

	return 0 ;
}


UINT InitServer( LPVOID pParam )
{

	CString cstrMessage ;
	char	szBuf[4096] ;
	SOCKET  LSock, CSock, *newSock;
	int     Rc;
	unsigned short usPort=1234;
	sockAndWinStruct sw ;

	CdebugserverDlg *dlg = (CdebugserverDlg*)pParam ;

	usPort = 7654 ;

	Tcp4uInit ();
	Rc = TcpGetListenSocket (&LSock, NULL, &usPort, 1);
	if (Rc!=TCP4U_SUCCESS)
	{
		sprintf (szBuf,"TCP4U error:%s - aborting...\n", Tcp4uErrorString(Rc));
		AfxMessageBox(szBuf, MB_OK) ;
		dlg->m_syncThreads = 1 ;
		dlg->PostMessage(WM_QUIT) ;
		return 0;
	}

	sprintf( szBuf, "%u", usPort ) ;
	cstrMessage = "TCP4U initialized\r\n" ;
	cstrMessage += "Listening for incoming connections on port " ;
	cstrMessage +=  szBuf ;
	cstrMessage +=  "\r\n" ;
	WriteMessage(dlg, NULL, (char*)(LPCTSTR)cstrMessage) ;

	/* --- now listen at port */
	while (dlg->m_syncThreads==0)
	{
		Rc = TcpAccept (&CSock, LSock, 1);
		if (Rc==TCP4U_SUCCESS)
		{

			newSock = new SOCKET ;
			memcpy(newSock, &CSock, sizeof(SOCKET)) ;
			sw.sock = newSock ;
			sw.wnd = dlg ;
			AfxBeginThread(DebugClientRequestThread, &sw) ;
		}
	}

	Tcp4uCleanup ();

	dlg->PostMessage(WM_QUIT) ;
	
	return 0 ;
}

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CdebugserverDlg dialog

CdebugserverDlg::CdebugserverDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CdebugserverDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CdebugserverDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CdebugserverDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CdebugserverDlg)
	DDX_Control(pDX, IDC_EDIT_MESSAGES, m_edMessages);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CdebugserverDlg, CDialog)
	//{{AFX_MSG_MAP(CdebugserverDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CdebugserverDlg message handlers




BOOL CdebugserverDlg::OnInitDialog()
{

	CDC         *pDC ;
	TEXTMETRIC  tm;
	int         nLineHeight ;
	RECT        rect ;

	CDialog::OnInitDialog();
	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	pDC = m_edMessages.GetDC() ;
	pDC->GetTextMetrics( &tm );
	nLineHeight = ((tm.tmHeight + tm.tmExternalLeading) * 8) / (GetDialogBaseUnits()>>16);
	nLineHeight = 13 ; //hack 
	m_edMessages.GetClientRect(&rect) ;
	m_nuiNumVisibleLines = ((rect.bottom - rect.top)+1) / nLineHeight ;

	m_syncThreads = 0 ;

	InitializeCriticalSection(&m_critSection);

	AfxBeginThread(InitServer, this) ;


	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CdebugserverDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CdebugserverDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CdebugserverDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CdebugserverDlg::OnOK() 
{
	CString cstrMessages ;

	if (m_syncThreads==0)
	{
		m_syncThreads = 1 ;
		WriteMessage(this, NULL, "Please wait...shutting down...\r\n") ;
		return ;
	}
	
	CDialog::OnOK();
}

void CdebugserverDlg::OnCancel() 
{

	CString cstrMessages ;

	if (m_syncThreads==0)
	{
		m_syncThreads = 1 ;
		WriteMessage(this, NULL, "Please wait...shutting down...\r\n") ;
		return ;
	}

	CDialog::OnCancel();
}

void CdebugserverDlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);

	if (m_syncThreads==0)
	{

	}

}
