#pragma once
#define _WIN32_WINNT 0x0400
#include <windows.h>
#include "CWaitable.h"

#define NS_PER_MSEC	10000		// nanoseconds per millisecond
#define NS_PER_SEC	10000000	// nanoseconds per second
#define MS_PER_SEC  1000		// milliseconds per second

/////////////////////////////////////////////////////////////////////////////////////////////
//
//	Implements a OS timer using the ::CreateWaitableTimer interface.
//

class CTimer : public CWaitable
{
	public:
		CTimer( bool bManualReset	= false )
			{ m_hTimer = ::CreateWaitableTimer( NULL, bManualReset, NULL ); }
		virtual ~CTimer() {;}

		bool Set( DWORD dwMsec, bool bResume = false );
		bool Cancel( void )
			{ return Set( 10 ); }

		// Waitable interface
		virtual HANDLE GetWaitHandle( void )
			{ return m_hTimer; }
		void CancelWait( void )
			{ Cancel(); }

	private:
		HANDLE			m_hTimer;
};
