#pragma once
#define _WIN32_WINNT 0x0400
#include <windows.h>
#include "CResourcePool.h"
#include "CCriticalSection.h"
#include "COsEvent.h"

class CRunnable;

/////////////////////////////////////////////////////////////////////////////////////////////
//
//		Encapsulates the Win32 thread api into a single object.  Implements the CPoolable
//		for interworking with resource pools.  Implements CWaitable which allows for 
//		waiting using CWaitableCollection.  All of the "staticness" of the Win32 API is
//		transparently handled as well.  Do NOT inherit from this class if
//		you want you object to run in it's own thread.  Rather, inherit from CRunnable, 
//		which is designed to use this class.
//
class CThread
	: 
	public CPoolable, 
	public CWaitable
{
	public:
		CThread();
		virtual ~CThread();

		bool Run( CRunnable* pRunnable );
		DWORD Suspend( void );
		DWORD Resume( void );

		/////////////////////////////////////////////////////////////////////////////////////
		//	Returns true if this thread is actively running a CRunnable object.
		bool IsInUse( void )
			{ return ( m_pRunnable != NULL ); }

		/////////////////////////////////////////////////////////////////////////////////////
		//	Returns the windows thread is associated with this thread.
		DWORD GetThreadId( void )	
			{ return m_dwThreadId; }

		// Waitable interface
		virtual HANDLE GetWaitHandle( void )
			{ return m_hThread; }
		virtual void CancelWait( void );

		// Poolable interface
		virtual long GetId( void )
			{ return GetThreadId(); }
		virtual void DetachFromPool( void );

	private:
		HANDLE					m_hThread;
		DWORD					m_dwThreadId;
		CRunnable*				m_pRunnable;
		CCriticalSection		m_ThreadStateLock;
		COsEvent				m_RunEvent;

		static DWORD WINAPI WinThreadEntry( void* pVoid );
		static void CThreadEntry( void* pVoid );
		int Run( void );
};

/////////////////////////////////////////////////////////////////////////////////////////////
//
//

class CThreadFactory : public CResourceFactory
{
	public:
		CThreadFactory()
			{;}
		virtual ~CThreadFactory()
			{;}

		virtual bool CreateInstance( CPoolable*& pObject )
			{ pObject = new CThread(); return true; }
};


