#pragma once
#include "CWaitable.h"
#include <string>

/////////////////////////////////////////////////////////////////////////////////////////
//
class CSocketEvent
{
	public:
		CSocketEvent()
			{ m_hEvent = ::WSACreateEvent(); }

		virtual ~CSocketEvent()
			{ ::WSACloseEvent( m_hEvent ); }

		bool Set( void )
			{ return ::WSASetEvent( m_hEvent ) == TRUE; }

		bool Reset( void )
			{ return ::WSAResetEvent( m_hEvent ) == TRUE; }

		DWORD WaitSingle( void )
			{ return ::WSAWaitForMultipleEvents( 1, &m_hEvent, false, WSA_INFINITE, false ); }

		operator WSAEVENT()
			{ return m_hEvent; }

	private:
		WSAEVENT	m_hEvent;
};

/////////////////////////////////////////////////////////////////////////////////////////
//
class CSocket : public CWaitable
{
	public:
		CSocket();
		virtual ~CSocket();

		bool Listen( LPCTSTR pszHostAddress, int iPort, int iBacklog );
		bool Accept( CSocket*& pClientSocket );

		bool Connect( LPCTSTR pszHostAddress, int iHostPort );
		bool Close( void );
		bool Shutdown(void);
		bool Create( void );

		bool Send( LPCSTR pBuffer, int iBufferLength );
		bool Receive( LPSTR pBuffer, int iBufferLength, int& iBytesReceived ) ;

		unsigned long GetLocalIpAddress( void );
		unsigned short GetLocalIpPort( void );

		unsigned long GetPeerIpAddress( void );
		unsigned short GetPeerIpPort( void );

		bool EventSelect( DWORD dwNetworkEvents );
		bool GetSignaledEvent( DWORD& dwNetworkEvents );
		void GetLastError( void );

		bool SetOption( int iLevel, int iOptName, const char* pszOptVal, int iOptLen );

		SOCKET GetHandle( void )
			{ return m_hSocket; }

		// Waitable interface
		virtual HANDLE GetWaitHandle( void )
			{ return m_Event; }
		void CancelWait( void )
			{ m_Event.Set(); }

		static bool ConvertIpAddress( unsigned long nIpAddress, std::string& sIpAddress );
		static bool InitWinsock( void );
		static void UnloadWinsock( void );

	private:
		SOCKET				m_hSocket;
		CSocketEvent		m_Event;

		CSocket( SOCKET hSocket );
		bool InitSocketAddress( SOCKADDR_IN* pSockAddr, LPCTSTR pszHostAddress, int iHostPort );
		void LogLastError( void );
};

