#pragma once
#include "CString.h"

/////////////////////////////////////////////////////////////////////////////////////////////
//
class CFormatBuffer
{
	public:
		CFormatBuffer( unsigned int iMaxLength = 1024 );
		virtual ~CFormatBuffer();

		int format( const char* pszFormat, ... );
		int format( const char* pszFormat, va_list argList );
		int append( const char* pszFormat, ... );
		int append( const char* pszFormat, va_list argList );
		int appendString( const char* pszData,int incrSize = -1);
		void empty( void );

		void toString( CStringEx& sString ) const;
		const char* toString( void ) const;
		char* data();
		int getLength( void ) const;
		int available() const;

		void ensureCapacity(int iAmount,int incrSize = -1);
		void expand(int iAmount = -1);

	private:
		char*				m_pszBuffer;
		unsigned int 		m_nMaxLength;

		int _format( char* pszBuffer, const char* pszFormat, va_list argList );
};

